/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;

public class SerialManager {
    private SerialPort serialPort;
    private String serialPortName;
    private int serialBaudRate;
    private int serialPortTimeout;
    private InputStream inputStream;
    private OutputStream outputStream;

    public String getSerialPortName() {
        return this.serialPortName;
    }

    public void setSerialPortName(String serialPortName) {
        this.serialPortName = serialPortName;
    }

    public int getSerialBaudRate() {
        return this.serialBaudRate;
    }

    public void setSerialBaudRate(int serialBaudRate) {
        this.serialBaudRate = serialBaudRate;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public void setSerialPort(SerialPort serialPort) {
        this.serialPort = serialPort;
    }

    public int getSerialPortTimeout() {
        return this.serialPortTimeout;
    }

    public void setSerialPortTimeout(int serialPortTimeout) {
        this.serialPortTimeout = serialPortTimeout;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void openSerialConnection() throws Exception {
        this.serialPort = this.getSerialPort(this.serialPortName);
        this.serialPort.setSerialPortParams(this.serialBaudRate, 8, 1, 0);
        this.serialPort.enableReceiveTimeout(this.serialPortTimeout);
        this.serialPort.disableReceiveThreshold();
        this.setInputStream(this.serialPort.getInputStream());
        this.setOutputStream(this.serialPort.getOutputStream());
    }

    public void close() {
        try {
            this.serialPort.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setInputStream(null);
        this.setOutputStream(null);
        this.serialPort = null;
    }

    public static Vector getSerialPortList() {
        Vector<String> vector = new Vector<String>();
        try {
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                CommPortIdentifier portID = (CommPortIdentifier)portList.nextElement();
                if (portID == null || portID.getName() == null || portID.getPortType() != 1) continue;
                vector.addElement(portID.getName());
            }
        }
        catch (Throwable t) {
            vector = null;
        }
        return vector;
    }

    public SerialPort getSerialPort(String serialPortName) throws IOException, NoSuchPortException, PortInUseException {
        CommPortIdentifier portID = null;
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        StringBuffer buffer = new StringBuffer();
        buffer.append("Serial Port Not Found : " + serialPortName + "\n");
        buffer.append("Serial Ports Available on this Machine : \n");
        while (portList.hasMoreElements()) {
            portID = (CommPortIdentifier)portList.nextElement();
            if (portID == null || portID.getPortType() != 1) continue;
            buffer.append("   " + portID.getName() + "\n");
            if (portID.getName().equals(serialPortName)) break;
        }
        if (portID == null && (portID = CommPortIdentifier.getPortIdentifier((String)serialPortName)) == null) {
            throw new IOException(buffer.toString());
        }
        SerialPort serialPort = (SerialPort)portID.open("the Alien RFID Java Library", 1000);
        if (serialPort == null) {
            throw new IOException(buffer.toString());
        }
        return serialPort;
    }

    public static void addPortName(String portName) {
        try {
            CommPortIdentifier commPort = null;
            try {
                commPort = CommPortIdentifier.getPortIdentifier((String)portName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (commPort == null) {
                CommPortIdentifier.addPortName((String)portName, (int)1, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        SerialManager sm = new SerialManager();
        Vector portList = SerialManager.getSerialPortList();
        if (portList != null) {
            System.out.println(portList.toString());
        } else {
            System.out.println("No Serial Ports found");
        }
    }
}

