/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.reader;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;

public class TimedSocket {
    private static final int POLL_DELAY = 100;

    public static Socket getSocket(InetAddress addr, int port, int delay) throws InterruptedIOException, IOException {
        Socket sock;
        SocketThread st;
        block4: {
            st = new SocketThread(addr, port);
            st.start();
            int timer = 0;
            sock = null;
            do {
                if (st.isConnected()) break block4;
                if (st.isError()) {
                    throw st.getException();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((timer += 100) <= delay);
            throw new InterruptedIOException("Connection timed out - could not connect for " + delay + " milliseconds");
        }
        sock = st.getSocket();
        return sock;
    }

    public static Socket getSocket(String host, int port, int delay) throws InterruptedIOException, IOException {
        InetAddress inetAddr = InetAddress.getByName(host);
        return TimedSocket.getSocket(inetAddr, port, delay);
    }

    static class SocketThread
    extends Thread {
        private volatile Socket m_connection = null;
        private String m_host = null;
        private InetAddress m_inet = null;
        private int m_port = 0;
        private IOException m_exception = null;

        public SocketThread(String host, int port) {
            this.m_host = host;
            this.m_port = port;
        }

        public SocketThread(InetAddress inetAddr, int port) {
            this.m_inet = inetAddr;
            this.m_port = port;
        }

        public void run() {
            Socket sock = null;
            try {
                sock = this.m_host != null ? new Socket(this.m_host, this.m_port) : new Socket(this.m_inet, this.m_port);
            }
            catch (IOException ioe) {
                this.m_exception = ioe;
                return;
            }
            this.m_connection = sock;
        }

        public boolean isConnected() {
            return this.m_connection != null;
        }

        public boolean isError() {
            return this.m_exception != null;
        }

        public Socket getSocket() {
            return this.m_connection;
        }

        public IOException getException() {
            return this.m_exception;
        }
    }
}

