/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.notify;

import com.alien.enterpriseRFID.externalio.ExternalIOUtil;
import com.alien.enterpriseRFID.notify.AlienMessageFormatException;
import com.alien.enterpriseRFID.notify.ErrorMessage;
import com.alien.enterpriseRFID.notify.Message;
import com.alien.enterpriseRFID.notify.MessageListener;
import com.alien.enterpriseRFID.notify.MessageListenerService;
import com.alien.enterpriseRFID.tags.TagUtil;
import com.alien.enterpriseRFID.util.Converters;
import com.alien.enterpriseRFID.util.XMLReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;

class MessageListenerEngine
extends Thread
implements MessageListener {
    private Socket socket = null;
    private String readerAddress = "";
    private MessageListenerService listenerService;
    private MessageListener listener;
    private boolean isDebug;
    protected int engineID;
    private boolean stillRunning = true;
    private Message messageTemplate;
    private SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public MessageListenerEngine(int engineID, Socket socket, MessageListenerService listenerService, boolean isDebug) {
        super("MessageListenerEngine");
        this.socket = socket;
        this.isDebug = isDebug;
        this.engineID = engineID;
        this.listenerService = listenerService;
        this.listener = listenerService != null ? listenerService : this;
    }

    public void halt() {
        this.stillRunning = false;
        if (this.socket != null && this.socket.isConnected()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void run() {
        ErrorMessage errorMessage2;
        this.readerAddress = this.socket.getInetAddress().getHostAddress();
        this.messageTemplate = new Message();
        this.messageTemplate.setReaderIPAddress(this.readerAddress);
        if (this.isDebug) {
            System.out.println("\nMessage Listener " + this.engineID + ": Reader Connected from " + this.readerAddress);
        }
        InputStreamReader inputStreamReader = null;
        OutputStream outputStream = null;
        try {
            inputStreamReader = new InputStreamReader(this.socket.getInputStream());
            outputStream = this.socket.getOutputStream();
        }
        catch (IOException ioe) {
            errorMessage2 = new ErrorMessage();
            errorMessage2.setReaderIPAddress(this.readerAddress);
            errorMessage2.setReason(ioe.getMessage());
            this.deliverMessageToListener(errorMessage2);
        }
        if (inputStreamReader != null && outputStream != null) {
            this.readMessages(inputStreamReader, outputStream);
        }
        try {
            this.socket.close();
            this.socket = null;
            if (this.isDebug) {
                System.out.println("Message Listener " + this.engineID + ": Reader Closed");
            }
        }
        catch (IOException ioe) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception errorMessage2) {
                    // empty catch block
                }
                this.socket = null;
            }
            errorMessage2 = new ErrorMessage();
            errorMessage2.setReason("Message Listener " + this.engineID + ": Error - stopped service: " + ioe.getMessage());
            this.deliverMessageToListener(errorMessage2);
        }
    }

    private void readMessages(InputStreamReader inputStreamReader, OutputStream outputStream) {
        if (inputStreamReader == null || outputStream == null) {
            return;
        }
        byte[] testBytes = new byte[1];
        StringBuffer stringBuffer = new StringBuffer();
        do {
            try {
                byte nextByte = (byte)inputStreamReader.read();
                if (nextByte > 0) {
                    stringBuffer.append((char)nextByte);
                    continue;
                }
                if (nextByte == 0) {
                    String messageText = stringBuffer.toString().trim();
                    if (this.isDebug) {
                        System.out.println("\nMessage Listener " + this.engineID + ": Read = \n" + Converters.toAsciiString(messageText) + " ...DONE");
                    }
                    Message message = messageText.startsWith("<") ? this.decodeMessageXML(messageText) : this.decodeMessageText(messageText);
                    this.deliverMessageToListener(message);
                    stringBuffer = new StringBuffer();
                    continue;
                }
                if (this.isDebug && stringBuffer.length() > 0) {
                    System.out.println("\nMessage Listener " + this.engineID + ": Read = \n" + Converters.toAsciiString(stringBuffer.toString()) + " ...TIMEOUT");
                }
                return;
            }
            catch (IOException ioe) {
                ErrorMessage errorMessage = new ErrorMessage();
                errorMessage.setReaderIPAddress(this.readerAddress);
                errorMessage.setReason(ioe.getMessage());
                errorMessage.setRawData(stringBuffer.toString());
                this.deliverMessageToListener(errorMessage);
            }
        } while (this.stillRunning);
    }

    private boolean deliverMessageToListener(Message message) {
        if (message == null || this.listener == null) {
            return true;
        }
        try {
            this.listener.messageReceived(message);
            return true;
        }
        catch (Exception ex) {
            if (this.isDebug) {
                System.out.println("\nMessage Listener " + this.engineID + ": Caught unchecked exception in messageReceived() callback:\n" + ex.getMessage());
            }
            return false;
        }
    }

    public Message decodeMessageXML(String messageXML) {
        String headerText = null;
        this.messageTemplate.setRawData(messageXML);
        XMLReader xmlReader = new XMLReader(messageXML);
        Hashtable hashtable = null;
        try {
            hashtable = xmlReader.readXML();
        }
        catch (ParseException ex) {
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setReaderIPAddress(this.readerAddress);
            errorMessage.setReason(ex.getMessage());
            errorMessage.setRawData(messageXML);
            return errorMessage;
        }
        headerText = (String)hashtable.get("ALIEN-RFID-READER-AUTO-NOTIFICATION");
        if (headerText == null) {
            headerText = (String)hashtable.get("ALIEN-RFID-READER-IO-STREAM");
            if (headerText != null) {
                this.messageTemplate.setReason("IO STREAM");
            } else {
                headerText = (String)hashtable.get("ALIEN-RFID-READER-TAG-STREAM");
                if (headerText != null) {
                    this.messageTemplate.setReason("TAG STREAM");
                } else {
                    headerText = messageXML;
                }
            }
        }
        try {
            this.decodeMessageXMLBody(this.messageTemplate, headerText);
            return this.messageTemplate;
        }
        catch (AlienMessageFormatException amfe) {
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setReaderIPAddress(this.readerAddress);
            errorMessage.setReason(amfe.getMessage());
            errorMessage.setRawData(messageXML);
            return errorMessage;
        }
    }

    public void decodeMessageXMLBody(Message message, String messageXML) throws AlienMessageFormatException {
        XMLReader xmlReader = new XMLReader(messageXML);
        try {
            Hashtable table = xmlReader.readXML();
            String str = (String)table.get("READERNAME");
            if (str != null) {
                message.setReaderName(str);
            }
            if ((str = (String)table.get("READERTYPE")) != null) {
                message.setReaderType(str);
            }
            if ((str = (String)table.get("IPADDRESS")) != null) {
                message.setReaderIPAddress(str);
            }
            if ((str = (String)table.get("MACADDRESS")) != null) {
                message.setReaderMACAddress(str);
            }
            if ((str = (String)table.get("COMMANDPORT")) != null) {
                message.setReaderCommandPort(new Integer(str));
            }
            if ((str = (String)table.get("HOSTNAME")) != null) {
                message.setReaderHostname(str);
            }
            if ((str = (String)table.get("REASON")) != null) {
                message.setReason(str);
            }
            try {
                str = (String)table.get("STARTTRIGGERLINES");
                if (str != null) {
                    message.setStartTriggerLines(new Integer(str));
                }
                if ((str = (String)table.get("STOPTRIGGERLINES")) != null) {
                    message.setStopTriggerLines(new Integer(str));
                }
            }
            catch (NumberFormatException e) {
                message.setStartTriggerLines(0);
                message.setStopTriggerLines(0);
            }
            if ((str = (String)table.get("TIME")) != null) {
                message.setDate(this.dateTimeFormat.parse(str));
            }
            if ((str = (String)table.get("ALIEN-RFID-TAG-LIST")) != null) {
                message.setTagList(TagUtil.decodeXMLTagList(str));
            } else {
                message.setTagList(TagUtil.decodeXMLTagList(messageXML));
            }
            str = (String)table.get("ALIEN-RFID-IO-LIST");
            if (str != null) {
                message.setIOList(ExternalIOUtil.decodeXMLIOList(str));
            } else {
                message.setIOList(ExternalIOUtil.decodeXMLIOList(messageXML));
            }
        }
        catch (NumberFormatException ex) {
            throw new AlienMessageFormatException("Message Listener " + this.engineID + ": Unable to parse a value. " + ex.getMessage());
        }
        catch (ParseException ex) {
            throw new AlienMessageFormatException(ex.getMessage());
        }
    }

    public Message decodeMessageText(String messageText) {
        int endPos;
        int endOfLinePos;
        int startPos;
        this.messageTemplate.setRawData(messageText);
        if (messageText.startsWith("#Alien RFID Reader Tag Stream")) {
            this.messageTemplate.setReason("TAG STREAM");
        } else if (messageText.startsWith("#Alien RFID Reader IO Stream")) {
            this.messageTemplate.setReason("IO STREAM");
        }
        String str = this.extractTextMessageData(messageText, "#ReaderName: ");
        if (str != null) {
            this.messageTemplate.setReaderName(str);
        }
        if ((str = this.extractTextMessageData(messageText, "#ReaderType: ")) != null) {
            this.messageTemplate.setReaderType(str);
        }
        if ((str = this.extractTextMessageData(messageText, "#IPAddress: ")) != null) {
            this.messageTemplate.setReaderIPAddress(str);
        }
        if ((str = this.extractTextMessageData(messageText, "#CommandPort: ")) != null) {
            this.messageTemplate.setReaderCommandPort(new Integer(str));
        }
        if ((str = this.extractTextMessageData(messageText, "MACAddress: ")) != null) {
            this.messageTemplate.setReaderMACAddress(str);
        }
        if ((str = this.extractTextMessageData(messageText, "Hostname: ")) != null) {
            this.messageTemplate.setReaderHostname(str);
        }
        if ((str = this.extractTextMessageData(messageText, "#Reason: ")) != null) {
            this.messageTemplate.setReason(str);
        }
        try {
            str = this.extractTextMessageData(messageText, "#StartTriggerLines: ");
            if (str != null) {
                this.messageTemplate.setStartTriggerLines(new Integer(str));
            }
            if ((str = this.extractTextMessageData(messageText, "#StopTriggerLines: ")) != null) {
                this.messageTemplate.setStopTriggerLines(new Integer(str));
            }
        }
        catch (NumberFormatException e) {
            this.messageTemplate.setStartTriggerLines(0);
            this.messageTemplate.setStopTriggerLines(0);
        }
        if ((str = this.extractTextMessageData(messageText, "#Time: ")) != null) {
            try {
                this.messageTemplate.setDate(this.dateTimeFormat.parse(str));
            }
            catch (ParseException ex) {
                ErrorMessage errorMessage = new ErrorMessage();
                errorMessage.setReaderIPAddress(this.messageTemplate.getReaderIPAddress());
                errorMessage.setReason(ex.getMessage());
                errorMessage.setRawData(messageText);
                return errorMessage;
            }
        }
        if ((startPos = messageText.indexOf("#StopTriggerLines:")) == -1 && (startPos = messageText.indexOf("#Reason:")) == -1) {
            startPos = 0;
        }
        if (startPos > 0 && (endOfLinePos = messageText.indexOf("\r\n", startPos)) > 0) {
            startPos += 2;
        }
        if ((endPos = messageText.indexOf("IO:", startPos)) == -1 && (endPos = messageText.indexOf("#End of Notification Message")) == -1) {
            endPos = messageText.length();
        }
        str = messageText.substring(startPos, endPos);
        if (this.listenerService.isCustomTagList()) {
            this.messageTemplate.setTagList(TagUtil.decodeCustomTagList(str));
        } else {
            this.messageTemplate.setTagList(TagUtil.decodeTagList(str));
        }
        startPos = endPos;
        endPos = messageText.indexOf("#End of Notification Message", startPos);
        if (endPos == -1) {
            endPos = messageText.length();
        }
        str = messageText.substring(startPos, endPos);
        this.messageTemplate.setIOList(ExternalIOUtil.decodeIOList(str));
        return this.messageTemplate;
    }

    private String extractTextMessageData(String messageText, String dataHeader) {
        int endPos;
        String result = null;
        int startPos = messageText.indexOf(dataHeader);
        if (startPos >= 0 && (endPos = messageText.indexOf("\r\n", startPos += dataHeader.length())) > startPos) {
            result = messageText.substring(startPos, endPos);
        }
        return result;
    }

    public void messageReceived(Message message) {
    }
}

