/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.discovery;

import com.alien.enterpriseRFID.discovery.AlienDiscoverySerialException;
import com.alien.enterpriseRFID.discovery.DiscoveryItem;
import com.alien.enterpriseRFID.discovery.DiscoveryListener;
import com.alien.enterpriseRFID.reader.AlienClass1Reader;
import com.alien.enterpriseRFID.reader.AlienClassOEMReader;
import com.alien.enterpriseRFID.reader.AlienReaderConnectionException;
import com.alien.enterpriseRFID.reader.AlienReaderException;
import com.alien.enterpriseRFID.reader.AlienReaderTimeoutException;
import com.alien.enterpriseRFID.util.SerialManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SerialDiscoveryListenerService
implements Runnable {
    public static final int SCANNING_PORT = 1;
    public static final int SCANNING_END = 2;
    public static final int SCANNING_PORTBUSY = 3;
    private SerialManager serialManager;
    private DiscoveryListener discoveryListener;
    private ActionListener actionListener;
    private Hashtable discoveryTable = new Hashtable();
    private Thread motor;
    public boolean isDebug = false;
    private boolean isRunning;
    private int maxSerialPort;
    private int serialBaudRate = 115200;
    private Vector serialPortVector = new Vector();

    public SerialDiscoveryListenerService() throws AlienDiscoverySerialException {
        try {
            Class.forName("javax.comm.CommPort");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                Class.forName("gnu.io.CommPort");
            }
            catch (ClassNotFoundException cnfe2) {
                this.serialManager = null;
                throw new AlienDiscoverySerialException("Serial Discovery Instance Failed - Serial Classes Not Present");
            }
        }
        this.serialManager = new SerialManager();
    }

    public DiscoveryListener getDiscoveryListener() {
        return this.discoveryListener;
    }

    public void setDiscoveryListener(DiscoveryListener discoveryListener) {
        this.discoveryListener = discoveryListener;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    public int getMaxSerialPort() {
        return this.maxSerialPort;
    }

    public void setMaxSerialPort(int maxPort) {
        this.maxSerialPort = maxPort;
    }

    public int getSerialBaudRate() {
        return this.serialBaudRate;
    }

    public void setSerialBaudRate(int serialBaudRate) {
        this.serialBaudRate = serialBaudRate;
    }

    public String getSerialPortList() {
        String portListString = this.serialPortVector.toString();
        return portListString.substring(1, portListString.length() - 1);
    }

    public void setSerialPortList(String portList) {
        this.serialPortVector = new Vector();
        if (portList == null || portList.equals("")) {
            return;
        }
        String[] portArray = portList.split(",");
        int i = 0;
        while (i < portArray.length) {
            String portName = portArray[i].trim();
            try {
                int portNum = Integer.parseInt(portName);
                portName = "COM" + portNum;
            }
            catch (Exception exception) {
                // empty catch block
            }
            SerialManager.addPortName(portName);
            this.serialPortVector.add(portName);
            ++i;
        }
    }

    public void startService() {
        if (this.motor != null) {
            return;
        }
        this.isRunning = true;
        this.motor = new Thread(this);
        this.motor.setPriority(1);
        this.motor.start();
        if (this.isDebug) {
            System.out.println("Serial Listener Service : Started");
        }
    }

    public void stopService() {
        if (this.isDebug && this.motor != null) {
            System.out.println("Serial Listener Service : Stopped");
        }
        this.motor = null;
        this.isRunning = false;
        this.fireActionEvent(2, "");
    }

    public void run() {
        Vector serialPortNames;
        this.isRunning = true;
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        Enumeration elements = this.discoveryTable.elements();
        while (elements.hasMoreElements()) {
            DiscoveryItem discoveryItem = (DiscoveryItem)elements.nextElement();
            discoveryItem.setLeaseTime(0);
        }
        if (this.serialManager != null && (serialPortNames = SerialManager.getSerialPortList()) != null) {
            int i = 0;
            while (i < serialPortNames.size()) {
                if (!this.isRunning) break;
                String name = (String)serialPortNames.elementAt(i);
                if (name != null && this.isValidSerialPort(name)) {
                    this.checkSerialPort(name);
                }
                ++i;
            }
        }
        this.checkForExpiredLeases();
        this.stopService();
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private boolean isValidSerialPort(String portName) {
        if (this.serialPortVector.size() > 0) {
            return this.serialPortVector.contains(portName);
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkSerialPort(String serialPortName) {
        this.fireActionEvent(1, serialPortName);
        DiscoveryItem item = new DiscoveryItem();
        item.setConnection("Serial");
        item.setReaderAddress(serialPortName);
        item.setLeaseTime(10000);
        AlienClass1Reader reader = new AlienClass1Reader(serialPortName);
        reader.setSerialBaudRate(this.serialBaudRate);
        if (this.isDebug) {
            reader.setDebugLevel(2);
        }
        try {
            reader.setTimeOutMilliseconds(1000);
            reader.setValidateOpen(false);
            reader.open();
            reader.sendString("\r\n");
            Thread.sleep(10L);
            String testResponse = reader.receiveString(false);
            reader.sendString("\r\n");
            testResponse = reader.receiveString(true).trim();
            if (!testResponse.endsWith("Alien>")) {
                reader.close();
                return;
            }
            Thread.sleep(200L);
            String readerName = null;
            String readerType = null;
            try {
                try {
                    try {
                        item.setReaderMACAddress(reader.getMACAddress());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    readerName = reader.getReaderName();
                    readerType = reader.getReaderType();
                }
                catch (AlienReaderException ex) {
                    if (this.isDebug) {
                        System.out.println(ex.toString());
                    }
                    if (readerName == null) {
                        readerName = "< Undetermined >";
                    }
                    if (readerType == null) {
                        readerType = "< Undetermined >";
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                reader.close();
                item.setReaderName(readerName);
                item.setReaderType(readerType);
                if (this.isDebug) {
                    System.out.println("SerialPort : " + serialPortName + " ... Present");
                }
                this.discoveryItemReceived(serialPortName, item);
                throw throwable;
            }
            {
                Object var8_15 = null;
                reader.close();
                item.setReaderName(readerName);
                item.setReaderType(readerType);
                if (this.isDebug) {
                    System.out.println("SerialPort : " + serialPortName + " ... Present");
                }
                this.discoveryItemReceived(serialPortName, item);
                return;
            }
        }
        catch (AlienReaderConnectionException arce) {
            this.fireActionEvent(3, serialPortName);
            reader.close();
            if (!this.isDebug) return;
            System.out.println("SerialPort : " + serialPortName + " ... In Use");
            return;
        }
        catch (AlienReaderTimeoutException toe) {
            if (this.isDebug) {
                System.out.println("Trying Alien OEM Reader Module...");
            }
            reader.close();
            try {
                reader = new AlienClassOEMReader(serialPortName);
                reader.setTimeOutMilliseconds(1000);
                reader.setValidateOpen(false);
                reader.open();
                reader.getReaderVersion();
                item.setReaderName(reader.getReaderName());
                item.setReaderType(reader.getReaderType());
                if (this.isDebug) {
                    System.out.println("SerialPort : " + serialPortName + " ... Present");
                }
                reader.close();
                this.discoveryItemReceived(serialPortName, item);
                return;
            }
            catch (Exception ex) {
                reader.close();
                if (!this.isDebug) return;
                System.out.println(ex);
                System.out.println("SerialPort : " + serialPortName + " ... Not Present");
                return;
            }
        }
        catch (Exception ex) {
            reader.close();
            if (!this.isDebug) return;
            System.out.println(ex);
            System.out.println("SerialPort : " + serialPortName + " ... Not Present");
        }
    }

    private void discoveryItemReceived(String serialPort, DiscoveryItem discoveryItem) {
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        String key = serialPort;
        DiscoveryItem existingDiscoveryItem = (DiscoveryItem)this.discoveryTable.get(key);
        try {
            if (!discoveryItem.equals(existingDiscoveryItem)) {
                existingDiscoveryItem = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (existingDiscoveryItem != null) {
            existingDiscoveryItem.setLastHeartbeat(new Date().getTime());
            existingDiscoveryItem.setLeaseTime(discoveryItem.getLeaseTime());
            if (this.discoveryListener != null) {
                this.discoveryListener.readerRenewed(existingDiscoveryItem);
            }
        } else {
            this.discoveryTable.put(key, discoveryItem);
            if (this.discoveryListener != null) {
                this.discoveryListener.readerAdded(discoveryItem);
            }
        }
    }

    private void checkForExpiredLeases() {
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        if (this.discoveryTable.size() <= 0) {
            return;
        }
        Enumeration keys = this.discoveryTable.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            DiscoveryItem discoveryItem = (DiscoveryItem)this.discoveryTable.get(key);
            if (discoveryItem.getLeaseTime() > 0) continue;
            this.discoveryItemExpired(discoveryItem);
        }
    }

    public void discoveryItemExpired(DiscoveryItem discoveryItem) {
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        this.discoveryTable.remove(discoveryItem.getReaderAddress());
        if (this.discoveryListener != null) {
            this.discoveryListener.readerRemoved(discoveryItem);
        }
    }

    public void allDiscoveryItemsExpired() {
        Enumeration elements = this.discoveryTable.elements();
        while (elements.hasMoreElements()) {
            DiscoveryItem di = (DiscoveryItem)elements.nextElement();
            this.discoveryItemExpired(di);
        }
    }

    public DiscoveryItem[] getDiscoveryItems() {
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        DiscoveryItem[] results = new DiscoveryItem[this.discoveryTable.size()];
        Enumeration items = this.discoveryTable.elements();
        int counter = 0;
        while (items.hasMoreElements()) {
            results[counter++] = (DiscoveryItem)items.nextElement();
        }
        return results;
    }

    private void fireActionEvent(int status, String message) {
        if (this.actionListener == null) {
            return;
        }
        this.actionListener.actionPerformed(new ActionEvent(this, status, message));
    }
}

