/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.util;

import java.util.StringTokenizer;

public class Converters {
    public static String toHexString(byte[] byteArray, String separator) {
        return Converters.toHexString(byteArray, separator, false);
    }

    public static String toHexString(byte[] byteArray, String separator, boolean isTagID) {
        if (byteArray == null) {
            return "NULL Bytes";
        }
        return Converters.toHexString(byteArray, 0, byteArray.length, separator, isTagID);
    }

    public static String toHexString(byte[] byteArray, int offset, int length, String separator) {
        return Converters.toHexString(byteArray, offset, length, separator, false);
    }

    public static String toHexString(byte[] byteArray, int offset, int length, String separator, boolean isTagID) {
        if (byteArray == null) {
            return "NULL Bytes";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuffer buffer = new StringBuffer();
        int evenCounter = 0;
        int i = length - 1;
        while (i >= 0) {
            if (offset + i < byteArray.length) {
                String token = Integer.toHexString(byteArray[offset + i] & 0xFF);
                buffer.insert(0, token);
                if (token.length() == 0) {
                    buffer.insert(0, "00");
                }
                if (token.length() == 1) {
                    buffer.insert(0, "0");
                }
                ++evenCounter;
                if (i > 0) {
                    if (!isTagID) {
                        buffer.insert(0, separator);
                    }
                    if (isTagID && evenCounter == 2) {
                        buffer.insert(0, separator);
                    }
                }
                if (evenCounter == 2) {
                    evenCounter = 0;
                }
            }
            --i;
        }
        return buffer.toString().toUpperCase().trim();
    }

    public static String toBinaryString(byte[] byteArray, int padLength) {
        if (byteArray == null) {
            return "NULL Bytes";
        }
        StringBuffer buffer = new StringBuffer();
        int i = byteArray.length - 1;
        while (i >= 0) {
            String token = Integer.toBinaryString(byteArray[i] & 0xFF);
            buffer.insert(0, token);
            if (i > 0) {
                int j = token.length();
                while (j < 8) {
                    buffer.insert(0, "0");
                    ++j;
                }
                buffer.insert(0, " ");
                ++padLength;
            }
            --i;
        }
        if (padLength > 0) {
            int l;
            int i2 = l = buffer.length();
            while (i2 < padLength) {
                buffer.insert(0, "0");
                ++i2;
            }
        }
        return buffer.toString();
    }

    public static String toHexString(long value, int byteCount) {
        byte[] byteArray = new byte[byteCount];
        if (byteCount >= 1) {
            byteArray[byteCount - 1] = (byte)(value & 0xFFL);
        }
        if (byteCount >= 2) {
            byteArray[byteCount - 2] = (byte)(value >> 8 & 0xFFL);
        }
        if (byteCount >= 3) {
            byteArray[byteCount - 3] = (byte)(value >> 16 & 0xFFL);
        }
        if (byteCount >= 4) {
            byteArray[byteCount - 4] = (byte)(value >> 24 & 0xFFL);
        }
        if (byteCount >= 5) {
            byteArray[byteCount - 5] = (byte)(value >> 32 & 0xFFL);
        }
        if (byteCount >= 6) {
            byteArray[byteCount - 6] = (byte)(value >> 40 & 0xFFL);
        }
        if (byteCount >= 7) {
            byteArray[byteCount - 7] = (byte)(value >> 48 & 0xFFL);
        }
        if (byteCount >= 8) {
            byteArray[byteCount - 8] = (byte)(value >> 56 & 0xFFL);
        }
        return Converters.toHexString(byteArray, "");
    }

    public static String toHexString(int value) {
        String result = "";
        if (value < 16) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + Integer.toHexString(value).toUpperCase();
        return result;
    }

    public static String toHexString(byte value) {
        String result = "";
        if ((value & 0xFF) < 16) {
            result = String.valueOf(result) + "0";
        }
        result = String.valueOf(result) + Integer.toHexString(value & 0xFF).toUpperCase();
        return result;
    }

    public static String toBinaryString(long value, int byteCount) {
        byte[] byteArray = new byte[byteCount];
        if (byteCount >= 1) {
            byteArray[byteCount - 1] = (byte)(value & 0xFFL);
        }
        if (byteCount >= 2) {
            byteArray[byteCount - 2] = (byte)(value >> 8 & 0xFFL);
        }
        if (byteCount >= 3) {
            byteArray[byteCount - 3] = (byte)(value >> 16 & 0xFFL);
        }
        if (byteCount >= 4) {
            byteArray[byteCount - 4] = (byte)(value >> 24 & 0xFFL);
        }
        if (byteCount >= 5) {
            byteArray[byteCount - 5] = (byte)(value >> 32 & 0xFFL);
        }
        if (byteCount >= 6) {
            byteArray[byteCount - 6] = (byte)(value >> 40 & 0xFFL);
        }
        if (byteCount >= 7) {
            byteArray[byteCount - 7] = (byte)(value >> 48 & 0xFFL);
        }
        if (byteCount >= 8) {
            byteArray[byteCount - 8] = (byte)(value >> 56 & 0xFFL);
        }
        return Converters.toBinaryString(byteArray, byteCount * 8);
    }

    public static byte[] fromHexString(String displayString) {
        int i;
        if (displayString == null) {
            return new byte[0];
        }
        if (displayString.length() < 1) {
            return new byte[0];
        }
        displayString = displayString.toUpperCase();
        StringTokenizer tokens = new StringTokenizer(displayString, " ");
        StringBuffer buffer = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            StringBuffer buf = new StringBuffer();
            String chunk = tokens.nextToken();
            i = 0;
            while (i < chunk.length()) {
                char c = chunk.charAt(i);
                if (c >= '0' && c <= '9') {
                    buf.append(c);
                }
                if (c >= 'A' && c <= 'F') {
                    buf.append(c);
                }
                ++i;
            }
            if (buf.length() / 2 * 2 != buf.length()) {
                buf.insert(0, "0");
            }
            buffer.append(buf.toString());
        }
        String bufferString = buffer.toString();
        byte[] byteArray = new byte[bufferString.length() / 2];
        i = 0;
        while (i < byteArray.length) {
            try {
                String token = bufferString.substring(i * 2, i * 2 + 2);
                token = "0x" + token;
                Integer integer = Integer.decode(token);
                byteArray[i] = (byte)integer.intValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return byteArray;
    }

    public static byte[] fromBinaryString(String displayString) {
        if (displayString == null) {
            return new byte[0];
        }
        if (displayString.length() < 1) {
            return new byte[0];
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < displayString.length()) {
            char c = displayString.charAt(i);
            if (c == '0' || c == '1') {
                buffer.append(c);
            }
            ++i;
        }
        int byteCount = buffer.length() / 8;
        if (byteCount * 8 != buffer.length()) {
            ++byteCount;
            do {
                buffer.insert(0, "0");
            } while (buffer.length() < byteCount * 8);
        }
        int stringIndex = buffer.length() - 1;
        byte[] byteArray = new byte[byteCount];
        int byteIndex = byteCount - 1;
        while (byteIndex >= 0) {
            int b = 0;
            int bitIndex = 7;
            while (bitIndex >= 0) {
                b *= 2;
                if (buffer.charAt(stringIndex - bitIndex) == '1') {
                    ++b;
                }
                --bitIndex;
            }
            stringIndex -= 8;
            byteArray[byteIndex] = (byte)b;
            --byteIndex;
        }
        return byteArray;
    }

    public static byte[] fromBinaryStringMSB(String displayString) {
        if (displayString == null) {
            return new byte[0];
        }
        if (displayString.length() < 1) {
            return new byte[0];
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < displayString.length()) {
            char c = displayString.charAt(i);
            if (c == '0' || c == '1') {
                buffer.append(c);
            }
            ++i;
        }
        int byteCount = buffer.length() / 8;
        if (byteCount * 8 < buffer.length()) {
            ++byteCount;
            do {
                buffer.append("0");
            } while (buffer.length() < byteCount * 8);
        }
        int stringIndex = buffer.length() - 1;
        byte[] byteArray = new byte[byteCount];
        int byteIndex = byteCount - 1;
        while (byteIndex >= 0) {
            int b = 0;
            int bitIndex = 7;
            while (bitIndex >= 0) {
                b *= 2;
                if (buffer.charAt(stringIndex - bitIndex) == '1') {
                    ++b;
                }
                --bitIndex;
            }
            stringIndex -= 8;
            byteArray[byteIndex] = (byte)b;
            --byteIndex;
        }
        return byteArray;
    }

    public static String toAsciiString(byte[] byteArray, int offset, int length) {
        String text = new String(byteArray, offset, length);
        String result = "";
        int i = 0;
        while (i < text.length()) {
            char character = text.charAt(i);
            if (character <= '\u001a') {
                result = String.valueOf(result) + "[";
                result = character == '\n' ? String.valueOf(result) + "lf" : (character == '\r' ? String.valueOf(result) + "cr" : (character == '\u0000' ? String.valueOf(result) + "null" : String.valueOf(result) + Converters.toHexString(character)));
                result = String.valueOf(result) + "]";
            } else {
                result = String.valueOf(result) + text.substring(i, i + 1);
            }
            ++i;
        }
        return result;
    }

    public static String toAsciiString(byte[] byteArray) {
        return Converters.toAsciiString(byteArray, 0, byteArray.length);
    }

    public static String toAsciiString(String string) {
        return Converters.toAsciiString(string.getBytes());
    }

    public static String toAsciiString(byte byteValue) {
        byte[] byteArray = new byte[]{byteValue};
        return Converters.toAsciiString(byteArray, 0, 1);
    }

    public static String reformatTagID(String tagID) {
        byte[] byteArray = Converters.fromHexString(tagID);
        return Converters.toHexString(byteArray, " ");
    }
}

