/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.reader;

import com.alien.enterpriseRFID.reader.AlienClass1Reader;
import com.alien.enterpriseRFID.reader.AlienReaderCommandErrorException;
import com.alien.enterpriseRFID.reader.AlienReaderConnectionException;
import com.alien.enterpriseRFID.reader.AlienReaderException;
import com.alien.enterpriseRFID.reader.AlienReaderInvalidArgumentException;
import com.alien.enterpriseRFID.reader.AlienReaderTimeoutException;
import com.alien.enterpriseRFID.tags.Tag;
import com.alien.enterpriseRFID.tags.TagTable;
import com.alien.enterpriseRFID.util.Converters;
import java.io.IOException;
import java.util.StringTokenizer;

public class AlienClass01Reader
extends AlienClass1Reader
implements Runnable {
    public TagTable tagTable;
    private int autoModeState = 0;
    private int acquireMode = 0;
    private int activeAntenna = 0;
    private int progAntenna = 0;
    private String antennaSequence = "0";
    private int tagType = 15;
    private int queryTimeout;
    private int timerTotalCommands;
    private int timerTotalTime;
    private Thread motor;
    private static final String ERROR_PREFIX = "Error: ";
    private String readerCommand;
    private String readerPreviousCommand;
    private String readerCommandValueString;
    private int readerCommandValueInt;
    private int[] readerCommandValueIntArray;
    private int[] readerCommandValueHexArray;
    private String[] readerCommandValueStringArray;
    private String internalReaderReply;
    public byte[] lastResponseBytes = new byte[4096];
    public byte[] lastCommandBytes = new byte[4096];
    public int lastResponseByteCount = 0;
    public int lastCommandByteCount = 0;

    public AlienClass01Reader(String address) {
        this.tagTable = new TagTable();
        this.setPersistTime(-1);
        if (address != "") {
            this.setConnection(address);
        }
        this.setValidateOpen(false);
    }

    public AlienClass01Reader() {
        this("");
    }

    public AlienClass01Reader(String ipAddress, int port) {
        this(String.valueOf(ipAddress) + ":" + port);
    }

    public void setDebugLevel(int level) {
        super.setDebugLevel(level);
    }

    public String issueReaderCommand(String commandString) throws AlienReaderConnectionException, AlienReaderTimeoutException, AlienReaderCommandErrorException {
        if (commandString == null || commandString.equals("")) {
            return null;
        }
        commandString = this.terminateString(commandString);
        this.sendBytes(commandString.getBytes());
        String r = new String(this.receiveBytes());
        if (r.indexOf("Error") != -1) {
            throw new AlienReaderCommandErrorException("Reader responded with an error to the command:\n" + commandString + "\n" + r);
        }
        return r;
    }

    private String terminateString(String s) {
        if (s.endsWith(";\n")) {
            return s;
        }
        if (s.endsWith(";")) {
            return String.valueOf(s) + "\n";
        }
        if (s.endsWith("\n")) {
            return String.valueOf(s.trim()) + ";\n";
        }
        return String.valueOf(s) + ";\n";
    }

    public int getTagType() {
        return this.tagType;
    }

    public void setTagType(int tagType) {
        if (tagType == 7) {
            tagType = 15;
        }
        this.tagType = tagType;
    }

    public void setPersistTime(int persistTime) {
        if (persistTime != -1) {
            persistTime *= 1000;
        }
        this.tagTable.setPersistTime(persistTime);
    }

    public int getPersistTime() {
        int persistTime = this.tagTable.getPersistTime();
        if (persistTime != -1) {
            persistTime /= 1000;
        }
        return persistTime;
    }

    public void clearTagList() {
        this.tagTable.clearTagList();
    }

    public Tag[] getTagList() throws AlienReaderException {
        return this.getTagList(1);
    }

    public Tag[] getTagList(int multiplier) throws AlienReaderException {
        if (this.autoModeState == 0) {
            this.tagTable.clearTagList();
            this.timerTotalCommands = multiplier;
            long startTime = System.currentTimeMillis();
            this.acquireTags(multiplier);
            this.timerTotalTime = (int)(System.currentTimeMillis() - startTime);
        }
        Tag[] tagList = this.tagTable.getTagList();
        if (this.autoModeState == 1 && this.tagTable.getPersistTime() == -1) {
            this.tagTable.clearTagList();
        }
        if (tagList == null) {
            return null;
        }
        if (tagList.length == 0) {
            return null;
        }
        return tagList;
    }

    public Tag[] getTagList(long readMillis) throws AlienReaderException {
        if (this.autoModeState == 0) {
            this.tagTable.clearTagList();
            this.timerTotalCommands = 1;
            long startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < readMillis) {
                this.acquireTags(1);
            }
        }
        Tag[] tagList = this.tagTable.getTagList();
        if (this.autoModeState == 1 && this.tagTable.getPersistTime() == -1) {
            this.tagTable.clearTagList();
        }
        if (tagList == null) {
            return null;
        }
        if (tagList.length == 0) {
            return null;
        }
        return tagList;
    }

    public Tag getTag() throws AlienReaderException {
        return this.getTag(1);
    }

    public Tag getTag(int multiplier) throws AlienReaderException {
        Tag[] tagList = this.getTagList(multiplier);
        if (tagList != null && tagList.length > 0) {
            return tagList[0];
        }
        return null;
    }

    public String getTagID() throws AlienReaderException {
        Tag tag = this.getTag();
        if (tag != null) {
            return tag.getTagID();
        }
        return "No Tag";
    }

    public int getAutoMode() {
        return this.autoModeState;
    }

    public void setAutoMode(int autoMode) {
        if (autoMode == 0) {
            this.autoModeState = 0;
            this.motor = null;
            try {
                this.issueReaderCommand("SET AUTO = OFF");
            }
            catch (AlienReaderException ex) {
                System.err.println("TM.setAutoMode(OFF): " + ex.getMessage());
            }
        } else {
            try {
                this.motor = new Thread(this);
                String cursor = this.constructAcquireQuery();
                try {
                    this.issueReaderCommand("CLOSE q1");
                }
                catch (AlienReaderException alienReaderException) {
                    // empty catch block
                }
                this.issueReaderCommand("DECLARE q1 CURSOR FOR " + cursor);
                this.issueReaderCommand("SET AUTO q1 = ON");
                this.autoModeState = 1;
                this.motor.start();
            }
            catch (AlienReaderException ex) {
                this.autoModeState = 0;
            }
        }
    }

    public void autoModeReset() {
        this.setAutoMode(0);
    }

    public String getAcquireMode() {
        if (this.acquireMode == 0) {
            return "Inventory";
        }
        return "Global Scroll";
    }

    public void setAcquireMode(String acquireMode) {
        this.acquireMode = acquireMode.toLowerCase().equals("Inventory".toLowerCase()) ? 0 : 1;
    }

    public String getReaderName() {
        return "Alien Class 1/0 Reader";
    }

    public String getReaderType() {
        String frequencyString = "915 MHz";
        String modelString = "9774";
        String numAntennasString = "Four Antennas";
        return "Alien Class 1/0 RFID Reader, Model: ALR-" + modelString + " (" + numAntennasString + " / EPC Class 1/0 / " + frequencyString + ")";
    }

    public String getReaderVersion() throws AlienReaderException {
        try {
            String r = this.issueReaderCommand("SELECT version FROM firmware");
            return r;
        }
        catch (AlienReaderCommandErrorException e) {
            String msg = "Error: getting ReaderVersion";
            msg = String.valueOf(msg) + "\n" + e.getMessage();
            throw new AlienReaderCommandErrorException(msg);
        }
    }

    public void reboot() throws AlienReaderException {
        try {
            this.issueReaderCommand("RESET");
        }
        catch (AlienReaderCommandErrorException e) {
            String msg = "Error: rebooting the reader";
            msg = String.valueOf(msg) + "\n" + e.getMessage();
            throw new AlienReaderCommandErrorException(msg);
        }
    }

    public void setActiveAntenna(int antennaNumber) {
        this.activeAntenna = antennaNumber;
    }

    public int getActiveAntenna() throws AlienReaderException {
        return this.activeAntenna;
    }

    public void setProgAntenna(int antennaNumber) throws AlienReaderException {
        this.progAntenna = antennaNumber;
    }

    public int getProgAntenna() throws AlienReaderException {
        return this.progAntenna;
    }

    public void setAntennaSequence(String sequenceString) throws AlienReaderException {
        this.antennaSequence = sequenceString;
    }

    public String getAntennaSequence() throws AlienReaderException {
        return this.antennaSequence;
    }

    public String verifyTag() throws AlienReaderException {
        String tagID;
        block3: {
            try {
                tagID = this.getTagID();
                if (tagID != null) break block3;
                return "No Tag Detected, or Tag Is Locked.";
            }
            catch (AlienReaderCommandErrorException e) {
                String msg = "Error: verifying tag";
                msg = String.valueOf(msg) + "\n" + e.getMessage();
                throw new AlienReaderCommandErrorException(msg);
            }
        }
        return tagID;
    }

    public void programTag(String tagID) throws AlienReaderException {
    }

    public void eraseTag() throws AlienReaderException {
    }

    public void killTag(String tagIDAndPassCode) throws AlienReaderException {
    }

    public void lockTag(String passCode) throws AlienReaderException {
    }

    public void run() {
        int currentTimeout = this.getTimeOutMilliseconds();
        this.setTimeOutMilliseconds(currentTimeout + 1000);
        Thread thisThread = Thread.currentThread();
        while (this.motor == thisThread) {
            if (this.getDebugLevel() > 0) {
                System.out.println("\nTM.run(): Waiting for tag data.");
            }
            try {
                String tagListString = new String(this.receiveBytes());
                this.parseTagListString(tagListString);
                if (this.getDebugLevel() > 0) {
                    System.out.println("TM.run(): Received tag data.");
                }
                this.tagTable.removeOldTags();
            }
            catch (AlienReaderException ex) {
                if (this.autoModeState == 1) {
                    System.out.println("TM.run(): " + ex.getMessage());
                }
                if (this.getDebugLevel() > 0) {
                    System.out.println("TM.run(): failing silently");
                }
                this.setTimeOutMilliseconds(currentTimeout);
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setTimeOutMilliseconds(currentTimeout);
    }

    private void acquireTags(int multiplier) throws AlienReaderException {
        String query = this.constructAcquireQuery();
        int i = 0;
        while (i < multiplier) {
            String tagListString = this.issueReaderCommand(query);
            this.parseTagListString(tagListString);
            ++i;
        }
    }

    private String constructAcquireQuery() {
        StringTokenizer antennaTokenizer = new StringTokenizer(this.antennaSequence, ",");
        String antennaString = "";
        this.queryTimeout = 0;
        boolean firstAntenna = true;
        int antennaCount = 0;
        while (antennaTokenizer.hasMoreTokens()) {
            int readAntenna;
            String readAntennaString = antennaTokenizer.nextToken();
            ++antennaCount;
            try {
                readAntenna = new Integer(readAntennaString) + 1;
            }
            catch (NumberFormatException ex) {
                readAntenna = 1;
            }
            if (firstAntenna) {
                antennaString = String.valueOf(antennaString) + "(antenna_id=" + readAntenna;
                firstAntenna = false;
                continue;
            }
            antennaString = String.valueOf(antennaString) + " OR antenna_id=" + readAntenna;
        }
        antennaString = String.valueOf(antennaString) + ")";
        String protocolString = "(";
        boolean firstProtocol = true;
        if ((this.tagType & 8) > 0) {
            firstProtocol = false;
            protocolString = String.valueOf(protocolString) + "protocol_id='EPC0'";
            this.queryTimeout += 100 * antennaCount;
        }
        if ((this.tagType & 7) > 0) {
            if (!firstProtocol) {
                protocolString = String.valueOf(protocolString) + " OR ";
            }
            protocolString = String.valueOf(protocolString) + "protocol_id='CC915'";
            this.queryTimeout += 100 * antennaCount;
        }
        protocolString = String.valueOf(protocolString) + ")";
        if (this.queryTimeout < 250) {
            this.queryTimeout = 250;
        }
        String query = "SELECT id,antenna_id,read_count FROM tag_id WHERE (" + antennaString + " AND " + protocolString + ") " + "SET time_out=" + this.queryTimeout;
        return query;
    }

    public void parseTagListString(String tagListString) {
        StringTokenizer tagListTokenizer = new StringTokenizer(tagListString, "\n");
        while (tagListTokenizer.hasMoreTokens()) {
            String tagString = tagListTokenizer.nextToken();
            String[] tagBits = tagString.split("\\|");
            if (tagBits != null && tagBits.length == 3) {
                String tagID = tagBits[0];
                tagID = this.formatTagID(tagID);
                String antennaString = tagBits[1];
                int antenna = 0;
                try {
                    antenna = new Integer(antennaString) - 1;
                }
                catch (NumberFormatException ex) {
                    antenna = 0;
                }
                String countString = tagBits[2];
                int count = 0;
                try {
                    count = new Integer(countString);
                }
                catch (NumberFormatException ex1) {
                    count = 1;
                }
                Tag tag = new Tag(tagID);
                tag.setAntenna(antenna);
                tag.setRenewCount(count);
                long time = System.currentTimeMillis();
                tag.setDiscoverTime(time);
                tag.setHostDiscoverTime(time);
                tag.setRenewTime(time);
                tag.setHostRenewTime(time);
                this.tagTable.addTag(tag);
                continue;
            }
            System.err.println("Error parsing taglist: " + tagString);
            if (tagBits == null) {
                System.out.println("tagBits = null");
                continue;
            }
            int j = 0;
            while (j < tagBits.length) {
                System.err.println("tagBits " + j + " = " + tagBits[j]);
                ++j;
            }
        }
    }

    private String formatTagID(String id) {
        int startPos;
        String r = "";
        int i = startPos = 6;
        while (i <= id.length() - 4) {
            r = String.valueOf(r) + id.substring(i, i + 4) + " ";
            i += 4;
        }
        return r.trim();
    }

    private String getReaderNameCLI() {
        return "ReaderName = " + this.getReaderName() + "\n";
    }

    private String getReaderTypeCLI() {
        return "ReaderType = " + this.getReaderType() + "\n";
    }

    private String rebootCLI() {
        try {
            this.reboot();
            return "Rebooting System...\n";
        }
        catch (AlienReaderException e) {
            return String.valueOf(e.getMessage()) + "\n";
        }
    }

    private String getAntennaSequenceCLI() {
        try {
            String sequence = this.getAntennaSequence();
            return "AntennaSequence (i, j, k...) = " + sequence + "\n";
        }
        catch (AlienReaderException e) {
            return String.valueOf(e.getMessage()) + "\n";
        }
    }

    private String setAntennaSequenceCLI() {
        try {
            this.setAntennaSequence(this.readerCommandValueString);
            return this.getAntennaSequenceCLI();
        }
        catch (AlienReaderException e) {
            return String.valueOf(e.getMessage()) + "\n";
        }
    }

    private String getProgAntennaCLI() {
        try {
            int antenna = this.getProgAntenna();
            return "ProgAntenna = " + antenna + "\n";
        }
        catch (AlienReaderException e) {
            return String.valueOf(e.getMessage()) + "\n";
        }
    }

    private String getTagTypeCLI() {
        return "TagType = " + this.tagType + "\n";
    }

    private String setTagTypeCLI() {
        this.setTagType(this.readerCommandValueInt);
        return this.getTagTypeCLI();
    }

    public String getTimer() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("#Timing Results\n");
        buffer.append("Total Time (ms) = " + this.timerTotalTime + "\n");
        int commandsSec = 0;
        if (this.timerTotalTime > 0) {
            commandsSec = this.timerTotalCommands * 1000 / this.timerTotalTime;
        }
        buffer.append("Total Commands=" + this.timerTotalCommands + "   Commands/Sec=" + commandsSec + "\n");
        Tag[] tagList = this.tagTable.getTagList();
        int totalTags = 0;
        if (tagList != null) {
            totalTags = tagList.length;
        }
        int tagsSec = 0;
        if (this.timerTotalTime > 0) {
            tagsSec = totalTags * 1000 / this.timerTotalTime;
        }
        buffer.append("Total Unique Tags=" + totalTags + "   Unique Tags/Sec=" + tagsSec + "\n");
        int totalReads = 0;
        int i = 0;
        while (i < totalTags) {
            if (tagList != null && tagList[i] != null) {
                totalReads += tagList[i].getRenewCount();
            }
            ++i;
        }
        int readsSec = 0;
        if (this.timerTotalTime > 0) {
            readsSec = totalReads * 1000 / this.timerTotalTime;
        }
        buffer.append("Total Tag Reads=" + totalReads + "   Reads/Sec=" + readsSec);
        return buffer.toString();
    }

    private String getTagListCLI() throws AlienReaderException {
        Tag[] tagList;
        if (this.readerCommandValueInt < 1) {
            this.readerCommandValueInt = 1;
        }
        if ((tagList = this.getTagList(this.readerCommandValueInt)) == null) {
            return "No Tags\n";
        }
        StringBuffer tagBuffer = new StringBuffer();
        int i = 0;
        while (i < tagList.length) {
            tagBuffer.append(String.valueOf(tagList[i].toLongString()) + "\n");
            ++i;
        }
        return tagBuffer.toString();
    }

    private String getPersistTimeCLI() {
        return "PersistTime (secs) = " + this.getPersistTime() + "\n";
    }

    private String setPersistTimeCLI() {
        this.setPersistTime(this.readerCommandValueInt);
        return this.getPersistTimeCLI();
    }

    private String clearTagListCLI() {
        this.clearTagList();
        return "Tag List has been cleared!\n";
    }

    private String getAutoModeCLI() {
        if (this.autoModeState == 1) {
            return "AutoMode = ON\n";
        }
        return "AutoMode = OFF\n";
    }

    private String setAutoModeCLI() {
        if (this.readerCommandValueString.toLowerCase().equals("on")) {
            this.setAutoMode(1);
        } else {
            this.setAutoMode(0);
        }
        return this.getAutoModeCLI();
    }

    private String resetAutoModeCLI() {
        this.autoModeReset();
        return "All auto-mode settings have been reset!\n";
    }

    private String getAcquireModeCLI() {
        if (this.getAcquireMode() == "Inventory") {
            return "AcquireMode = Inventory\n";
        }
        return "AcquireMode = Global Scroll\n";
    }

    private String setAcquireModeCLI() {
        this.setAcquireMode(this.readerCommandValueString);
        return this.getAcquireModeCLI();
    }

    private String verifyTagCLI() {
        try {
            return "Verify Tag = " + this.verifyTag() + "\n";
        }
        catch (AlienReaderException ex) {
            return "Verify Tag = " + ex.getMessage();
        }
    }

    private String programTagCLI() {
        try {
            this.programTag(this.readerCommandValueString);
            return "Program Tag = Success!\n";
        }
        catch (AlienReaderInvalidArgumentException iae) {
            return String.valueOf(iae.getMessage()) + "\n";
        }
        catch (AlienReaderException are) {
            return "Error: Error Programming Tag - " + are.getMessage() + "\n";
        }
    }

    private String eraseTagCLI() {
        try {
            this.eraseTag();
            return "Erase Tag = Success\n";
        }
        catch (AlienReaderException are) {
            return "Error: Error Erasing Tag - " + are.getMessage() + "\n";
        }
    }

    private String killTagCLI() {
        try {
            this.killTag(this.readerCommandValueString);
            return "Kill Tag = Success\n";
        }
        catch (AlienReaderException are) {
            return "Error: Error Killing Tag - " + are.getMessage() + "\n";
        }
    }

    private String lockTagCLI() {
        try {
            this.lockTag("" + this.readerCommandValueHexArray[0]);
            return "Lock Tag = Success\n";
        }
        catch (AlienReaderException are) {
            return "Error: Error Locking Tag - " + are.getMessage() + "\n";
        }
    }

    public String readerCommandCLI() {
        try {
            String r = this.issueReaderCommand(this.readerCommandValueString);
            String reply = "To Reader  :  " + this.readerCommandValueString + "\n";
            reply = String.valueOf(reply) + "From Reader:  " + r + "\n";
            return reply;
        }
        catch (AlienReaderException e) {
            return e.getMessage();
        }
    }

    private String getDebugCLI() {
        switch (this.getDebugLevel()) {
            case 0: {
                return "Debug = Off\n";
            }
            case 2: {
                return "Debug = Bytes\n";
            }
            case 1: {
                return "Debug = Text\n";
            }
        }
        return "Debug = Unknown\n";
    }

    private String setDebugCLI() {
        String level = this.readerCommandValueString.toLowerCase();
        if (level.equals("bytes")) {
            this.setDebugLevel(2);
        } else if (level.equals("text")) {
            this.setDebugLevel(1);
        } else {
            this.setDebugLevel(0);
        }
        return this.getDebugCLI();
    }

    private String getHelpCLI() {
        String reply = "***********************************************\n";
        reply = String.valueOf(reply) + "*\n";
        reply = String.valueOf(reply) + "* Help\n";
        reply = String.valueOf(reply) + "*\n";
        reply = String.valueOf(reply) + "***********************************************\n";
        reply = String.valueOf(reply) + "GENERAL:\n";
        reply = String.valueOf(reply) + "   Help (H)\n";
        reply = String.valueOf(reply) + "   Info (I)\n";
        reply = String.valueOf(reply) + "   ! (Repeat Last Command)\n";
        reply = String.valueOf(reply) + "   Get ReaderName\n";
        reply = String.valueOf(reply) + "   Get ReaderType\n";
        reply = String.valueOf(reply) + "   Get ReaderVersion\n";
        reply = String.valueOf(reply) + "   Get|Set AntennaSequence (i, j, k...)\n";
        reply = String.valueOf(reply) + "   Get|Set TagType\n";
        reply = String.valueOf(reply) + "   Reboot\n";
        reply = String.valueOf(reply) + "TAGLIST:\n";
        reply = String.valueOf(reply) + "   Get|Set AcquireMode\n";
        reply = String.valueOf(reply) + "   Get|Set PersistTime (secs)\n";
        reply = String.valueOf(reply) + "   Get TagList {n}\n";
        reply = String.valueOf(reply) + "   Clear TagList\n";
        reply = String.valueOf(reply) + "AUTONOMOUS MODE:\n";
        reply = String.valueOf(reply) + "   Get|Set Automode (On or Off)\n";
        reply = String.valueOf(reply) + "   AutoModeReset\n";
        reply = String.valueOf(reply) + "PROGRAMMING:\n";
        reply = String.valueOf(reply) + "   Program Tag = XX XX XX XX XX XX XX XX\n";
        reply = String.valueOf(reply) + "   Verify Tag\n";
        reply = String.valueOf(reply) + "   Erase Tag\n";
        reply = String.valueOf(reply) + "   Kill Tag = XX XX XX XX XX XX XX XX YY\n";
        reply = String.valueOf(reply) + "   Lock Tag = YY\n";
        reply = String.valueOf(reply) + "   Get|Set ProgAntenna\n";
        reply = String.valueOf(reply) + "MISC:\n";
        reply = String.valueOf(reply) + "   Get Timer\n";
        reply = String.valueOf(reply) + "   RC = [RQL command]\n";
        reply = String.valueOf(reply) + "\n";
        reply = String.valueOf(reply) + "(XX = TagID byte)\n(YY = LockCode byte)\n";
        return reply;
    }

    private String getInfoCLI() {
        String reply = "***********************************************\n";
        reply = String.valueOf(reply) + "*\n";
        reply = String.valueOf(reply) + "* Current Settings\n";
        reply = String.valueOf(reply) + "*\n";
        reply = String.valueOf(reply) + "***********************************************\n";
        reply = String.valueOf(reply) + "GENERAL:\n";
        reply = String.valueOf(reply) + "   " + this.getReaderNameCLI();
        reply = String.valueOf(reply) + "   " + this.getReaderTypeCLI();
        reply = String.valueOf(reply) + "   " + this.getAntennaSequenceCLI();
        reply = String.valueOf(reply) + "   " + this.getTagTypeCLI();
        reply = String.valueOf(reply) + "TAG LIST:\n";
        reply = String.valueOf(reply) + "   " + this.getPersistTimeCLI();
        reply = String.valueOf(reply) + "   " + this.getAcquireModeCLI();
        reply = String.valueOf(reply) + "AUTONOMOUS MODE:\n";
        reply = String.valueOf(reply) + "   " + this.getAutoModeCLI();
        reply = String.valueOf(reply) + "PROGRAMMING:\n";
        reply = String.valueOf(reply) + "   " + this.getProgAntennaCLI();
        return reply;
    }

    public void sendString(String command) throws AlienReaderConnectionException {
        if (command.trim().equals("!")) {
            command = this.readerPreviousCommand;
        } else {
            this.readerPreviousCommand = command;
        }
        this.processReaderCommand(command.trim());
        String lowerCommand = command.toLowerCase().trim();
        String reply = "";
        try {
            reply = lowerCommand.equals("get readername") ? this.getReaderNameCLI() : (lowerCommand.equals("get readertype") ? this.getReaderTypeCLI() : (lowerCommand.equals("get readerversion") ? String.valueOf(this.getReaderVersion()) + "\n" : (lowerCommand.equals("h") || lowerCommand.equals("help") ? this.getHelpCLI() : (lowerCommand.equals("i") || lowerCommand.startsWith("info") ? this.getInfoCLI() : (lowerCommand.equals("get antennasequence") ? this.getAntennaSequenceCLI() : (lowerCommand.startsWith("set antennasequence") ? this.setAntennaSequenceCLI() : (lowerCommand.equals("get tagtype") ? this.getTagTypeCLI() : (lowerCommand.startsWith("set tagtype") ? this.setTagTypeCLI() : (lowerCommand.equals("reboot") ? this.rebootCLI() : (lowerCommand.equals("get timer") ? String.valueOf(this.getTimer()) + "\n" : (lowerCommand.equals("") ? "" : (lowerCommand.startsWith("get taglist") || lowerCommand.startsWith("t") ? this.getTagListCLI() : (lowerCommand.equals("get persisttime") ? this.getPersistTimeCLI() : (lowerCommand.startsWith("set persisttime") ? this.setPersistTimeCLI() : (lowerCommand.equals("clear taglist") ? this.clearTagListCLI() : (lowerCommand.equals("get acquiremode") ? this.getAcquireModeCLI() : (lowerCommand.startsWith("set acquiremode") ? this.setAcquireModeCLI() : (lowerCommand.equals("get automode") ? this.getAutoModeCLI() : (lowerCommand.startsWith("set automode") ? this.setAutoModeCLI() : (lowerCommand.equals("automodereset") ? this.resetAutoModeCLI() : (lowerCommand.startsWith("set function") ? "Command Not Supported\n" : (lowerCommand.equals("verify tag") ? this.verifyTagCLI() : (lowerCommand.startsWith("program tag") ? this.programTagCLI() : (lowerCommand.equals("erase tag") ? this.eraseTagCLI() : (lowerCommand.startsWith("kill tag") ? this.killTagCLI() : (lowerCommand.startsWith("lock tag") ? this.lockTagCLI() : (lowerCommand.startsWith("set debug") ? this.setDebugCLI() : "Command Not Understood\n")))))))))))))))))))))))))));
        }
        catch (AlienReaderException are) {
            reply = ERROR_PREFIX + are.getMessage();
        }
        catch (Exception ex) {
            reply = "Error: Unhandled Exception.\n" + ex.getMessage();
            ex.printStackTrace();
        }
        this.internalReaderReply = command.getBytes()[0] == 1 ? String.valueOf(reply) + "\n" : String.valueOf(command) + reply + "\nAlien>";
    }

    private void processReaderCommand(String command) {
        this.readerCommand = "";
        this.readerCommandValueString = "";
        this.readerCommandValueInt = 0;
        this.readerCommandValueIntArray = null;
        this.readerCommandValueHexArray = null;
        this.readerCommandValueStringArray = null;
        this.readerCommand = command.trim();
        int index = this.readerCommand.indexOf("=");
        if (index <= 0) {
            index = this.readerCommand.lastIndexOf(" ");
        }
        if (index >= 0) {
            this.readerCommandValueString = this.readerCommand.substring(index + 1).trim();
        }
        if (this.readerCommandValueString.length() <= 0) {
            return;
        }
        try {
            this.readerCommandValueInt = new Integer(this.readerCommandValueString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringTokenizer tokenizer = new StringTokenizer(this.readerCommandValueString);
        int tokenCount = tokenizer.countTokens();
        this.readerCommandValueIntArray = new int[tokenCount];
        this.readerCommandValueHexArray = new int[tokenCount];
        this.readerCommandValueStringArray = new String[tokenCount];
        tokenizer = new StringTokenizer(this.readerCommandValueString);
        index = 0;
        while (tokenizer.hasMoreTokens()) {
            String token;
            this.readerCommandValueStringArray[index] = token = tokenizer.nextToken().trim();
            try {
                this.readerCommandValueHexArray[index] = Integer.valueOf(token, 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.readerCommandValueIntArray[index] = Integer.valueOf(token, 10);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++index;
        }
    }

    public String receiveString(boolean blockForInput) {
        String result = this.internalReaderReply;
        this.internalReaderReply = "";
        return result;
    }

    public void sendBytes(byte[] bytes) throws AlienReaderConnectionException {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        if (this.getDebugLevel() == 2) {
            System.out.println("  To Reader: " + Converters.toHexString(bytes, " "));
        } else if (this.getDebugLevel() == 1) {
            System.out.println("  To Reader: " + new String(bytes).trim());
        }
        this.lastCommandByteCount = bytes.length;
        int i = 0;
        while (i < this.lastCommandByteCount) {
            this.lastCommandBytes[i] = bytes[i];
            ++i;
        }
        try {
            this.getOutputStream().write(bytes);
            this.getOutputStream().flush();
        }
        catch (IOException ioe) {
            throw new AlienReaderConnectionException(ioe.getMessage());
        }
    }

    public byte[] receiveBytes() throws AlienReaderConnectionException, AlienReaderTimeoutException {
        long startTime = System.currentTimeMillis();
        boolean done = false;
        byte[] inputBuffer = new byte[4096];
        int readLength = 0;
        int bufferPos = 0;
        if (this.getDebugLevel() != 0) {
            System.out.print("From Reader: ");
        }
        do {
            block14: {
                try {
                    if (this.getInputStream() == null || this.getInputStream().available() <= 0 || (readLength = this.getInputStream().read(inputBuffer, bufferPos, inputBuffer.length - bufferPos)) <= 0) break block14;
                    if (this.getDebugLevel() == 2) {
                        System.out.print(Converters.toHexString(inputBuffer, bufferPos, readLength, " "));
                    } else if (this.getDebugLevel() == 1) {
                        System.out.print(Converters.toAsciiString(inputBuffer, bufferPos, readLength));
                    }
                    bufferPos += readLength;
                    if (inputBuffer[0] == 10) {
                        done = true;
                        break block14;
                    }
                    int i = 0;
                    while (i < bufferPos - 1) {
                        if (i < inputBuffer.length && inputBuffer[i] == 10 && inputBuffer[i + 1] == 10) {
                            done = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (IOException ioe) {
                    System.out.println("TM: Unable to read data. " + ioe.getMessage());
                    ioe.printStackTrace(System.out);
                }
            }
            if (System.currentTimeMillis() - startTime <= (long)this.getTimeOutMilliseconds()) continue;
            if (this.getDebugLevel() == 2) {
                System.out.println(" ... TIMEOUT\n");
            }
            throw new AlienReaderTimeoutException("Error: Timeout Waiting for Input Data");
        } while (!done);
        if (this.getDebugLevel() != 0) {
            System.out.println(" ... DONE\n");
        }
        if (bufferPos >= 0) {
            byte[] result = new byte[bufferPos];
            int i = 0;
            while (i < bufferPos) {
                result[i] = inputBuffer[i];
                ++i;
            }
            return result;
        }
        return null;
    }

    public String toString() {
        return "Alien Class 1/0 RFID Reader";
    }
}

