/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.externalio;

import com.alien.enterpriseRFID.externalio.ExternalIO;
import com.alien.enterpriseRFID.util.XMLReader;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ExternalIOUtil {
    public static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");

    public static ExternalIO[] decodeXMLIOList(String xmlData) {
        ArrayList<ExternalIO> ioList = new ArrayList<ExternalIO>();
        try {
            XMLReader xmlReader = new XMLReader(xmlData);
            Hashtable table = xmlReader.readXML();
            String ioData = (String)table.get("ALIEN-RFID-IO-LIST");
            if (ioData != null) {
                xmlReader.setXMLString(ioData);
            } else {
                xmlReader.setXMLString(xmlData);
            }
            while (xmlReader.readXMLNode(table)) {
                ExternalIO io;
                ioData = (String)table.get("ALIEN-RFID-IO");
                if (ioData == null || (io = ExternalIOUtil.decodeXMLIO(ioData)) == null) continue;
                ioList.add(io);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ioList.toArray(new ExternalIO[ioList.size()]);
    }

    public static ExternalIO decodeXMLIO(String xmlData) {
        try {
            XMLReader xmlReader = new XMLReader(xmlData);
            Hashtable table = xmlReader.readXML();
            String ioData = (String)table.get("ALIEN-RFID-IO-LIST");
            if (ioData != null) {
                xmlReader.setXMLString(ioData);
                table = xmlReader.readXML();
            }
            if ((ioData = (String)table.get("ALIEN-RFID-IO")) != null) {
                xmlReader.setXMLString(ioData);
                table = xmlReader.readXML();
            }
            ExternalIO io = new ExternalIO();
            io.setType((String)table.get("TYPE"));
            String dateString = (String)table.get("TIME");
            if (dateString != null) {
                Date date = DATE_FORMATTER.parse(dateString, new ParsePosition(0));
                io.setEventTime(date.getTime());
            }
            String valueString = (String)table.get("DATA");
            int value = new Integer(valueString);
            io.setValue(value);
            return io;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ExternalIO[] decodeIOList(String ioLines) {
        ArrayList<ExternalIO> ioList = new ArrayList<ExternalIO>();
        StringTokenizer tokenizer = new StringTokenizer(ioLines, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            ExternalIO io = ExternalIOUtil.decodeIO(token);
            if (io == null) continue;
            ioList.add(io);
        }
        return ioList.toArray(new ExternalIO[ioList.size()]);
    }

    public static ExternalIO decodeIO(String ioLine) {
        if (ioLine == null || ioLine.equals("")) {
            return null;
        }
        if (ioLine.startsWith("(No IOs)")) {
            return null;
        }
        ExternalIO io = new ExternalIO();
        if (ioLine.startsWith("IO:")) {
            String dateString;
            Date date;
            int start = 3;
            int end = ioLine.indexOf(",", start);
            if (end >= start) {
                io.setType(ioLine.substring(start, end).trim());
            }
            if ((start = ioLine.indexOf("Time:")) >= 0 && (end = ioLine.indexOf(",", start)) > start && (date = DATE_FORMATTER.parse(dateString = ioLine.substring(start + 5, end).trim(), new ParsePosition(0))) != null) {
                io.setEventTime(date.getTime());
            }
            if ((start = ioLine.indexOf("Data:")) >= 0) {
                try {
                    int count = new Integer(ioLine.substring(start + 5).trim());
                    io.setValue(count);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            return null;
        }
        return io;
    }
}

