/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.tags;

import com.alien.enterpriseRFID.tags.CustomFormat;
import com.alien.enterpriseRFID.tags.Tag;
import com.alien.enterpriseRFID.util.XMLReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;

public class TagUtil {
    private static String customFormatStr = "";
    private static CustomFormat cf = new CustomFormat(customFormatStr);

    public static void setCustomFormatString(String customFormatString) {
        customFormatStr = customFormatString;
        String javaVer = System.getProperty("java.version");
        cf = !javaVer.startsWith("1.3") && !javaVer.startsWith("1.2") && !javaVer.startsWith("1.1") ? new CustomFormat(customFormatStr) : null;
    }

    public static String getCustomFormatString() {
        return customFormatStr;
    }

    public static Tag[] decodeXMLTagList(String xmlData) {
        Hashtable<String, Integer> uniqueTags = new Hashtable<String, Integer>();
        ArrayList<Tag> tempTaglist = new ArrayList<Tag>();
        try {
            XMLReader xmlReader = new XMLReader(xmlData);
            Hashtable table = xmlReader.readXML();
            String tagData = (String)table.get("ALIEN-RFID-TAG-LIST");
            if (tagData != null) {
                xmlReader.setXMLString(tagData);
            } else {
                xmlReader.setXMLString(xmlData);
            }
            while (xmlReader.readXMLNode(table)) {
                Tag tag;
                tagData = (String)table.get("ALIEN-RFID-TAG");
                if (tagData == null || (tag = TagUtil.decodeXMLTag(tagData)) == null) continue;
                String taghash = String.valueOf(tag.getTagID()) + "," + tag.getTransmitAntenna();
                Integer existingIndex = (Integer)uniqueTags.get(taghash);
                if (existingIndex != null) {
                    Tag existingTag = (Tag)tempTaglist.get(existingIndex);
                    existingTag.updateTag(tag);
                    continue;
                }
                tag.setHostDiscoverTime(System.currentTimeMillis());
                tempTaglist.add(tag);
                uniqueTags.put(taghash, new Integer(tempTaglist.size()));
            }
        }
        catch (Exception xmlReader) {
            // empty catch block
        }
        Tag[] taglist = new Tag[tempTaglist.size()];
        tempTaglist.toArray(taglist);
        return taglist;
    }

    public static Tag decodeXMLTag(String xmlData) {
        try {
            String protocolString;
            String antennaString;
            Date date;
            XMLReader xmlReader = new XMLReader(xmlData);
            Hashtable table = xmlReader.readXML();
            String tagData = (String)table.get("ALIEN-RFID-TAG-LIST");
            if (tagData != null) {
                xmlReader.setXMLString(tagData);
                table = xmlReader.readXML();
            }
            if ((tagData = (String)table.get("ALIEN-RFID-TAG")) != null) {
                xmlReader.setXMLString(tagData);
                table = xmlReader.readXML();
            }
            Tag tag = new Tag("");
            tag.setTagID((String)table.get("TAGID"));
            String countString = (String)table.get("READCOUNT");
            int count = new Integer(countString);
            tag.setRenewCount(count);
            String dateString = (String)table.get("DISCOVERYTIME");
            if (dateString != null) {
                date = TagUtil.parseDateAndTime(dateString);
                tag.setDiscoverTime(date.getTime());
            }
            if ((dateString = (String)table.get("LASTSEENTIME")) != null) {
                date = TagUtil.parseDateAndTime(dateString);
                tag.setRenewTime(date.getTime());
                tag.lastRenewTime = 0L;
            }
            if ((antennaString = (String)table.get("ANTENNA")) != null) {
                int antenna = new Integer(antennaString);
                tag.setAntenna(antenna);
            }
            if ((protocolString = (String)table.get("PROTOCOL")) != null) {
                try {
                    int protocol = new Integer(protocolString);
                    tag.setProtocol(protocol);
                }
                catch (NumberFormatException ex) {
                    tag.setProtocol(protocolString);
                }
            }
            int i = 1;
            while (i <= 4) {
                String g2Data = (String)table.get("D" + i);
                if (g2Data == null) break;
                tag.setG2Data(i - 1, g2Data);
                ++i;
            }
            return tag;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Tag[] decodeTagList(String tagLines) {
        Hashtable<String, Integer> uniqueTags = new Hashtable<String, Integer>();
        ArrayList<Tag> tempTaglist = new ArrayList<Tag>();
        StringTokenizer tokenizer = new StringTokenizer(tagLines, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Tag tag = TagUtil.decodeTag(token);
            if (tag == null) continue;
            String taghash = String.valueOf(tag.getTagID()) + "," + tag.getTransmitAntenna();
            Integer existingIndex = (Integer)uniqueTags.get(taghash);
            if (existingIndex != null) {
                Tag existingTag = (Tag)tempTaglist.get(existingIndex);
                existingTag.updateTag(tag);
                continue;
            }
            tag.setHostDiscoverTime(System.currentTimeMillis());
            tempTaglist.add(tag);
            uniqueTags.put(taghash, new Integer(tempTaglist.size() - 1));
        }
        Tag[] taglist = new Tag[tempTaglist.size()];
        tempTaglist.toArray(taglist);
        return taglist;
    }

    public static Tag decodeTag(String tagLine) {
        if (tagLine == null || tagLine.equals("")) {
            return null;
        }
        if (tagLine.startsWith("(No Tags)")) {
            return null;
        }
        Tag tag = new Tag("");
        if (tagLine.startsWith("Tag:")) {
            Date date;
            String dateString;
            int start = 4;
            int end = tagLine.indexOf(",", start);
            if (end >= start) {
                tag.setTagID(tagLine.substring(start, end).trim());
            } else {
                tag.setTagID(tagLine.substring(start));
            }
            start = tagLine.indexOf("Disc:");
            if (start >= 0 && (end = tagLine.indexOf(",", start)) > start) {
                dateString = "";
                try {
                    dateString = " " + tagLine.substring(start + 5, end).trim() + " ";
                    date = TagUtil.parseDateAndTime(dateString);
                    if (date != null) {
                        tag.setDiscoverTime(date.getTime());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((start = tagLine.indexOf("Last:")) >= 0 && (end = tagLine.indexOf(",", start)) > start) {
                dateString = "";
                try {
                    dateString = tagLine.substring(start + 5, end).trim();
                    date = TagUtil.parseDateAndTime(dateString);
                    if (date != null) {
                        tag.setRenewTime(date.getTime());
                        tag.lastRenewTime = 0L;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((start = tagLine.indexOf("Count:")) >= 0 && (end = tagLine.indexOf(",", start)) > start) {
                try {
                    int count = new Integer(tagLine.substring(start + 6, end).trim());
                    tag.setRenewCount(count);
                }
                catch (NumberFormatException count) {
                    // empty catch block
                }
            }
            if ((start = tagLine.indexOf("Ant:")) >= 0) {
                end = tagLine.indexOf(",", start);
                if (end < 0 && (end = tagLine.indexOf("\n", start)) < 0) {
                    end = tagLine.length();
                }
                try {
                    int antenna = new Integer(tagLine.substring(start + 4, end).trim());
                    tag.setAntenna(antenna);
                }
                catch (NumberFormatException antenna) {
                    // empty catch block
                }
            }
            if ((start = tagLine.indexOf("Proto:")) >= 0) {
                end = tagLine.indexOf(",", start);
                if (end < 0 && (end = tagLine.indexOf("\n", start)) < 0) {
                    end = tagLine.length();
                }
                try {
                    int protocol = new Integer(tagLine.substring(start + 6, end).trim());
                    tag.setProtocol(protocol);
                }
                catch (NumberFormatException protocol) {
                    // empty catch block
                }
            }
            int i = 1;
            while (i <= 4) {
                start = tagLine.indexOf("D" + i + ":");
                if (start >= 0) {
                    end = tagLine.indexOf(",", start);
                    if (end < 0 && (end = tagLine.indexOf("\n", start)) < 0) {
                        end = tagLine.length();
                    }
                    tag.setG2Data(i - 1, tagLine.substring(start + 3, end).trim());
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            return null;
        }
        return tag;
    }

    public static Tag[] decodeCustomTagList(String tagLines, String customFormatString) {
        TagUtil.setCustomFormatString(customFormatString);
        return TagUtil.decodeCustomTagList(tagLines);
    }

    public static Tag[] decodeCustomTagList(String tagLines) {
        Hashtable<String, Integer> uniqueTags = new Hashtable<String, Integer>();
        ArrayList<Tag> tempTaglist = new ArrayList<Tag>();
        StringTokenizer tokenizer = new StringTokenizer(tagLines, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            Tag tag = TagUtil.decodeCustomTag(token);
            if (tag == null) continue;
            String taghash = String.valueOf(tag.getTagID()) + "," + tag.getTransmitAntenna();
            Integer existingIndex = (Integer)uniqueTags.get(taghash);
            if (existingIndex != null) {
                Tag existingTag = (Tag)tempTaglist.get(existingIndex);
                existingTag.updateTag(tag);
                continue;
            }
            tag.setHostDiscoverTime(System.currentTimeMillis());
            tempTaglist.add(tag);
            uniqueTags.put(taghash, new Integer(tempTaglist.size() - 1));
        }
        Tag[] taglist = new Tag[tempTaglist.size()];
        tempTaglist.toArray(taglist);
        return taglist;
    }

    public static Tag decodeCustomTag(String tagLine) {
        Tag tag;
        block57: {
            block56: {
                Date date;
                if (cf == null) {
                    return null;
                }
                String discTime = " ";
                String lastTime = " ";
                tag = new Tag("");
                Matcher matcher = cf.getPattern().matcher(tagLine);
                if (tagLine == null || tagLine.equals("") || tagLine.startsWith("(No Tags)")) {
                    return null;
                }
                if (!matcher.matches()) break block56;
                int[] tokens = cf.getTokens();
                int i = 1;
                while (i <= matcher.groupCount()) {
                    String match = matcher.group(i);
                    switch (tokens[i - 1]) {
                        case 1: {
                            tag.setTagID(match);
                            break;
                        }
                        case 2: {
                            date = TagUtil.parseDateAndTime(match);
                            if (date == null) break;
                            tag.setDiscoverTime(date.getTime());
                            break;
                        }
                        case 6: {
                            date = TagUtil.parseDateAndTime(match);
                            if (date == null) break;
                            tag.setRenewTime(date.getTime());
                            break;
                        }
                        case 4: {
                            discTime = String.valueOf(match) + discTime;
                            break;
                        }
                        case 5: {
                            discTime = String.valueOf(discTime) + match;
                            break;
                        }
                        case 8: {
                            lastTime = String.valueOf(match) + lastTime;
                            break;
                        }
                        case 9: {
                            lastTime = String.valueOf(lastTime) + match;
                            break;
                        }
                        case 3: {
                            tag.setDiscoverTime(Long.parseLong(match));
                            break;
                        }
                        case 7: {
                            tag.setRenewTime(Long.parseLong(match));
                            break;
                        }
                        case 10: {
                            tag.setRenewCount(Integer.parseInt(match));
                            break;
                        }
                        case 11: {
                            tag.setTransmitAntenna(Integer.parseInt(match));
                            break;
                        }
                        case 12: {
                            tag.setReceiveAntenna(Integer.parseInt(match));
                            break;
                        }
                        case 13: {
                            if (match == null) break;
                            tag.setProtocol(Integer.parseInt(match));
                            break;
                        }
                        case 14: {
                            tag.setProtocol(match);
                            break;
                        }
                        case 15: {
                            if (match == null) break;
                            tag.setG2Data(0, match);
                            break;
                        }
                        case 16: {
                            if (match == null) break;
                            tag.setG2Data(1, match);
                            break;
                        }
                        case 17: {
                            if (match == null) break;
                            tag.setG2Data(2, match);
                            break;
                        }
                        case 18: {
                            if (match == null) break;
                            tag.setG2Data(3, match);
                            break;
                        }
                        case 19: {
                            tag.setSpeed(Double.parseDouble(match));
                            break;
                        }
                        case 21: {
                            tag.setRSSI(Double.parseDouble(match));
                            break;
                        }
                        case 20: {
                            if ("-".equals(match)) {
                                tag.setDirection(-1);
                                break;
                            }
                            if ("+".equals(match)) {
                                tag.setDirection(1);
                                break;
                            }
                            tag.setDirection(0);
                            break;
                        }
                        case 22: {
                            tag.setTagAuth(match);
                            break;
                        }
                        case 23: {
                            tag.setPCWord(match);
                            break;
                        }
                        case 24: {
                            tag.setXPC(match);
                            break;
                        }
                        case 33: {
                            tag.setG2Ops(0, match);
                            break;
                        }
                        case 25: {
                            tag.setG2Ops(1, match);
                            break;
                        }
                        case 26: {
                            tag.setG2Ops(2, match);
                            break;
                        }
                        case 27: {
                            tag.setG2Ops(3, match);
                            break;
                        }
                        case 28: {
                            tag.setG2Ops(4, match);
                            break;
                        }
                        case 29: {
                            tag.setG2Ops(5, match);
                            break;
                        }
                        case 30: {
                            tag.setG2Ops(6, match);
                            break;
                        }
                        case 31: {
                            tag.setG2Ops(7, match);
                            break;
                        }
                        case 32: {
                            tag.setG2Ops(8, match);
                        }
                    }
                    ++i;
                }
                switch (discTime.length()) {
                    case 11: {
                        date = TagUtil.parseDate(discTime);
                        if (date == null) break;
                        tag.setDiscoverTime(date.getTime());
                        break;
                    }
                    case 9: 
                    case 13: {
                        date = TagUtil.parseTime(discTime);
                        if (date != null) {
                            tag.setDiscoverTime(date.getTime());
                        }
                    }
                    case 19: 
                    case 23: {
                        date = TagUtil.parseDateAndTime(discTime);
                        if (date == null) break;
                        tag.setDiscoverTime(date.getTime());
                    }
                }
                switch (lastTime.length()) {
                    case 11: {
                        date = TagUtil.parseDate(lastTime);
                        if (date != null) {
                            tag.setRenewTime(date.getTime());
                            break;
                        }
                        break block57;
                    }
                    case 9: 
                    case 13: {
                        date = TagUtil.parseTime(lastTime);
                        if (date != null) {
                            tag.setRenewTime(date.getTime());
                        }
                    }
                    case 19: 
                    case 23: {
                        date = TagUtil.parseDateAndTime(lastTime);
                        if (date == null) break block57;
                        tag.setRenewTime(date.getTime());
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block57;
            }
            return null;
        }
        return tag;
    }

    public static Date parseDateAndTime(String dateString) {
        if (dateString == null) {
            return null;
        }
        dateString = dateString.trim();
        int year = Integer.parseInt(dateString.substring(0, 4));
        int month = Integer.parseInt(dateString.substring(5, 7));
        int day = Integer.parseInt(dateString.substring(8, 10));
        int hour = Integer.parseInt(dateString.substring(11, 13));
        int minute = Integer.parseInt(dateString.substring(14, 16));
        int second = Integer.parseInt(dateString.substring(17, 19));
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day, hour, minute, second);
        if (dateString.length() >= 23) {
            int millis = Integer.parseInt(dateString.substring(20, 23));
            cal.set(14, millis);
        }
        return cal.getTime();
    }

    public static Date parseDate(String dateString) {
        if (dateString == null) {
            return null;
        }
        dateString = dateString.trim();
        int year = Integer.parseInt(dateString.substring(0, 4));
        int month = Integer.parseInt(dateString.substring(5, 7));
        int day = Integer.parseInt(dateString.substring(8, 10));
        GregorianCalendar cal = new GregorianCalendar(year, month - 1, day);
        return cal.getTime();
    }

    public static Date parseTime(String timeString) {
        if (timeString == null) {
            return null;
        }
        timeString = timeString.trim();
        int hour = Integer.parseInt(timeString.substring(0, 2));
        int minute = Integer.parseInt(timeString.substring(3, 5));
        int second = Integer.parseInt(timeString.substring(6, 8));
        GregorianCalendar cal = new GregorianCalendar(1970, 0, 1, hour, minute, second);
        if (timeString.length() >= 12) {
            int millis = Integer.parseInt(timeString.substring(9, 12));
            cal.set(14, millis);
        }
        return cal.getTime();
    }

    public static String taglistAsString(Tag[] taglist) {
        if (taglist == null) {
            taglist = new Tag[]{};
        }
        StringBuffer buf = new StringBuffer("Taglist (" + taglist.length + " tags):\r\n");
        int i = 0;
        while (i < taglist.length) {
            buf.append(taglist[i].toLongString()).append("\r\n");
            ++i;
        }
        return buf.toString();
    }
}

