/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.tags;

import com.alien.enterpriseRFID.tags.Tag;
import com.alien.enterpriseRFID.tags.TagTableListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TagTable
extends Hashtable {
    public static final int FOREVER = -1;
    private int persistTime;
    private TagTableListener tagTableListener;
    private boolean combineAntennaData;

    public TagTable(boolean antennaCombine) {
        this.combineAntennaData = antennaCombine;
        this.clearTagList();
    }

    public TagTable() {
        this(true);
    }

    public int getPersistTime() {
        return this.persistTime;
    }

    public void setPersistTime(int persistTime) {
        this.persistTime = persistTime;
        Enumeration tagList = this.keys();
        while (tagList.hasMoreElements()) {
            String tagHash = (String)tagList.nextElement();
            Tag tag = (Tag)this.get(tagHash);
            tag.setPersistTime(persistTime);
        }
    }

    public void clearTagList() {
        this.clear();
    }

    public boolean addTag(Tag tag) {
        if (tag == null) {
            return false;
        }
        Tag existingTag = (Tag)this.get(this.getTagHash(tag));
        if (existingTag == null) {
            tag.setHostDiscoverTime(System.currentTimeMillis());
            tag.setPersistTime(this.persistTime);
            this.put(this.getTagHash(tag), tag);
            if (this.tagTableListener != null) {
                this.tagTableListener.tagAdded(tag);
            }
            return true;
        }
        existingTag.updateTag(tag);
        if (this.tagTableListener != null) {
            this.tagTableListener.tagRenewed(existingTag);
        }
        return false;
    }

    public boolean removeTag(Tag tag) {
        if (tag == null) {
            return false;
        }
        Object object = this.remove(this.getTagHash(tag));
        return object != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOldTags() {
        Enumeration tagList;
        if (this.size() <= 0) {
            return false;
        }
        if (this.persistTime == -1) {
            return false;
        }
        boolean result = false;
        Enumeration enumeration = tagList = this.keys();
        synchronized (enumeration) {
            while (tagList.hasMoreElements()) {
                long timeToLive;
                String tagHash = (String)tagList.nextElement();
                Tag tag = (Tag)this.get(tagHash);
                if (tag == null || (timeToLive = tag.getTimeToLive()) > 0L) continue;
                this.remove(tagHash);
                if (this.tagTableListener != null) {
                    this.tagTableListener.tagRemoved(tag);
                }
                result = true;
            }
        }
        return result;
    }

    public Tag[] getTagList() {
        if (this.size() <= 0) {
            return null;
        }
        Vector<Tag> vector = new Vector<Tag>();
        Enumeration tagList = this.keys();
        while (tagList.hasMoreElements()) {
            String tagHash = (String)tagList.nextElement();
            Tag tag = (Tag)this.get(tagHash);
            vector.addElement(tag);
        }
        Object[] results = new Tag[vector.size()];
        vector.copyInto(results);
        return results;
    }

    public TagTableListener getTagTableListener() {
        return this.tagTableListener;
    }

    public void setTagTableListener(TagTableListener tagTableListener) {
        this.tagTableListener = tagTableListener;
    }

    private String getTagHash(Tag tag) {
        if (this.combineAntennaData) {
            return tag.getTagID();
        }
        return String.valueOf(tag.getTagID()) + "," + tag.getTransmitAntenna();
    }
}

