/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.reader;

import com.alien.enterpriseRFID.reader.AlienClass1Reader;
import com.alien.enterpriseRFID.reader.AlienReaderCommandErrorException;
import com.alien.enterpriseRFID.reader.AlienReaderException;
import com.alien.enterpriseRFID.reader.AlienReaderNoTagException;
import com.alien.enterpriseRFID.tags.Tag;
import com.alien.enterpriseRFID.tags.TagUtil;
import com.alien.enterpriseRFID.util.Converters;
import java.util.StringTokenizer;

public class AlienClassBPTReader
extends AlienClass1Reader {
    public static final short NO_READING = 9999;
    public static final short NO_WRITING = 9999;
    public static final int DEFAULT_TIMEOUT = 20000;

    public AlienClassBPTReader() {
        this.setTimeOutMilliseconds(20000);
    }

    public Tag getTagID(String tagID) throws Exception {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        this.doReaderCommand("get tagID");
        Tag[] tagList = null;
        tagList = this.getReaderReply().startsWith("<") ? TagUtil.decodeXMLTagList(this.getReaderReply()) : TagUtil.decodeTagList(this.getReaderReply());
        if (tagList == null) {
            return null;
        }
        if (tagList.length == 0) {
            return null;
        }
        return tagList[0];
    }

    public String getTagInfo(String tagID) throws AlienReaderException {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        return this.doReaderCommand("Get TagInfo");
    }

    public int getSensorValue(String tagID) throws AlienReaderException {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        this.doReaderCommand("get sensorvalue");
        if (this.getReaderReply().toLowerCase().indexOf("sensorvalue") < 0) {
            throw new AlienReaderCommandErrorException(this.getReaderReplyValueString());
        }
        if (this.getReaderReplyValueString().indexOf("No Tag") >= 0) {
            throw new AlienReaderNoTagException(this.getReaderReplyValueString());
        }
        return this.getReaderReplyValueInt();
    }

    public boolean isLogging(String tagID) throws AlienReaderException {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        this.doReaderCommand("get loggingmode");
        if (this.getReaderReplyValueString().indexOf("No Tag") >= 0) {
            throw new AlienReaderNoTagException(this.getReaderReplyValueString());
        }
        return this.getReaderReplyValueString().toLowerCase().indexOf("on") >= 0;
    }

    public void setLogging(String tagID, boolean isLogging) throws AlienReaderException {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        String value = "Off";
        if (isLogging) {
            value = "On";
        }
        this.doReaderCommand("set loggingmode = " + value);
        if (this.getReaderReplyValueString().indexOf("No Tag") >= 0) {
            throw new AlienReaderNoTagException(this.getReaderReplyValueString());
        }
    }

    public byte[] getLoggingInterval(String tagID) throws AlienReaderException {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        this.doReaderCommand("get loggingInterval");
        if (this.getReaderReplyValueString().indexOf("No Tag") >= 0) {
            throw new AlienReaderNoTagException(this.getReaderReplyValueString());
        }
        byte[] result = new byte[3];
        StringTokenizer tokenizer = new StringTokenizer(this.getReaderReplyValueString(), ":");
        try {
            result[0] = (byte)new Integer(tokenizer.nextToken()).intValue();
            result[1] = (byte)new Integer(tokenizer.nextToken()).intValue();
            result[2] = (byte)new Integer(tokenizer.nextToken()).intValue();
        }
        catch (Exception e) {
            throw new AlienReaderCommandErrorException("Data Format Error : " + this.getReaderReplyValueString());
        }
        return result;
    }

    public void setLoggingInterval(String tagID, byte[] byteArray) throws AlienReaderException {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        this.doReaderCommand("set loggingInterval = " + byteArray[0] + ":" + byteArray[1] + ":" + byteArray[2]);
        if (this.getReaderReplyValueString().indexOf("No Tag") >= 0) {
            throw new AlienReaderNoTagException(this.getReaderReplyValueString());
        }
    }

    public void setLoggingInterval(String tagID, int hours, int mins, int secs) throws AlienReaderException {
        byte[] byteArray = new byte[]{(byte)(hours & 0xFF), (byte)(mins & 0xFF), (byte)(secs & 0xFF)};
        this.setLoggingInterval(tagID, byteArray);
    }

    public short[] getMemory(String tagID, int lengthIndex, int startIndex) throws AlienReaderException {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        this.doReaderCommand("get memory = " + lengthIndex + ", " + startIndex);
        int resultIndex = 0;
        short[] resultArray = new short[lengthIndex];
        int i = 0;
        while (i < resultArray.length) {
            resultArray[i] = 9999;
            ++i;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.getReaderReplyValueString(), "\n\r");
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken();
            int index = line.indexOf("=");
            if (index > 0) {
                line = line.substring(index + 1).trim();
            }
            index = 0;
            while (index < line.length() - 1) {
                int result = 0;
                int b1 = line.charAt(index++);
                int b2 = line.charAt(index++);
                if (b1 == 42 || b2 == 42) {
                    result = 9999;
                } else {
                    if (b1 >= 65) {
                        b1 = b1 - 65 + 57 + 1;
                    }
                    if (b1 >= 48) {
                        b1 -= 48;
                    }
                    if (b2 >= 65) {
                        b2 = b2 - 65 + 57 + 1;
                    }
                    if (b2 >= 48) {
                        b2 -= 48;
                    }
                    result = (short)(b1 * 16 + b2);
                }
                ++index;
                if (resultIndex >= resultArray.length) continue;
                resultArray[resultIndex++] = result;
            }
        }
        return resultArray;
    }

    public boolean setMemory(String tagID, int startIndex, byte[] byteArray) {
        try {
            if (tagID != null) {
                this.setTagMask(tagID);
            }
            String readerCommand = "set memory = " + startIndex + ", ";
            readerCommand = String.valueOf(readerCommand) + Converters.toHexString(byteArray, " ");
            this.doReaderCommand(readerCommand);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void clearMemory(String tagID) throws AlienReaderException {
        if (tagID != null) {
            this.setTagMask(tagID);
        }
        this.doReaderCommand("clear memory ");
    }

    public int getMemoryPacketSize() throws AlienReaderException {
        this.doReaderCommand("Get MemoryPacketSize");
        return this.getReaderReplyValueInt();
    }

    public void setMemoryPacketSize(int memoryPacketSize) throws AlienReaderException {
        this.doReaderCommand("Set MemoryPacketSize = " + memoryPacketSize);
    }

    public String toString() {
        return "Alien Class BPT Reader";
    }
}

