/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.notify;

import com.alien.enterpriseRFID.notify.Message;
import com.alien.enterpriseRFID.notify.MessageListener;
import com.alien.enterpriseRFID.notify.MessageListenerEngine;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.util.Vector;

public class MessageListenerService
implements Runnable,
MessageListener {
    private Thread motor;
    private Vector engineList;
    private int listenerPort;
    private InetAddress listenerInterface;
    private MessageListener messageListener;
    private ServerSocketChannel serverSocket;
    private boolean isDebug;
    private boolean isRunning = false;
    private boolean isCustomTaglist = false;

    public MessageListenerService() {
        this(3600);
    }

    public MessageListenerService(int listenerPort) {
        this(listenerPort, null);
    }

    public MessageListenerService(int listenerPort, InetAddress listenerInterface) {
        this.setListenerPort(listenerPort);
        this.setListenerInterface(listenerInterface);
        this.setDebug(false);
        this.serverSocket = null;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public int getListenerPort() {
        return this.listenerPort;
    }

    public void setListenerPort(int listenerPort) {
        this.listenerPort = listenerPort;
    }

    public InetAddress getListenerInterface() {
        return this.listenerInterface;
    }

    public void setListenerInterface(InetAddress listenerInterface) {
        this.listenerInterface = listenerInterface;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public boolean isCustomTagList() {
        return this.isCustomTaglist;
    }

    public void setIsCustomTagList(boolean isCustom) {
        this.isCustomTaglist = isCustom;
    }

    public void startService() throws IOException {
        if (this.motor != null) {
            this.stopService();
        }
        try {
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.socket().bind(new InetSocketAddress(this.getListenerInterface(), this.getListenerPort()));
            this.serverSocket.configureBlocking(false);
            if (this.isDebug) {
                System.out.println("Message Listener: Listening on port " + this.getListenerPort());
            }
            this.motor = new Thread(this);
            this.motor.setDaemon(true);
            this.motor.start();
        }
        catch (IOException e) {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                    this.serverSocket = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.getListenerInterface() != null) {
                throw new IOException("Could not listen on " + this.getListenerInterface().getHostAddress() + ":" + this.getListenerPort() + ". Is that port in use or the interface unavailable?");
            }
            throw new IOException("Could not listen on port " + this.getListenerPort() + ". Is that port in use?");
        }
        if (this.isDebug) {
            System.out.println("Message Listener: Service Started on Port " + this.getListenerPort());
        }
        this.isRunning = true;
    }

    public void stopService() {
        if (this.isDebug) {
            System.out.println("Stopping motor.");
        }
        this.motor = null;
        if (this.isDebug) {
            System.out.println("Closing server socket.");
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        while (this.isRunning) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isDebug) {
            System.out.println("Message Listener: Service Stopped on Port " + this.getListenerPort());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block26: {
            currentEngineID = 0;
            this.engineList = new Vector<E>();
            try {
                try {
                    block12: while (true) {
                        if ((socketChannel = this.serverSocket.accept()) != null) {
                            if (this.isDebug) {
                                System.out.println("MLS: Accepted connection.");
                            }
                            engine = new MessageListenerEngine(currentEngineID++, socketChannel.socket(), this, this.isDebug);
                            if (this.isDebug) {
                                System.out.println("MLS: Starting new MessageListenerEngine.");
                            }
                            engine.start();
                            this.engineList.add(engine);
                        } else {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException engine) {
                                // empty catch block
                            }
                        }
                        iterator = this.engineList.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                if (this.motor != null) continue block12;
                            }
                            anEngine = (MessageListenerEngine)iterator.next();
                            if (anEngine.isAlive()) continue;
                            iterator.remove();
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    System.err.println("Failed to accept a connection on port: " + this.getListenerPort());
                }
            }
            catch (Throwable var6_8) {
                var5_9 = null;
                try {
                    if (this.serverSocket == null) throw var6_8;
                    this.serverSocket.close();
                    this.serverSocket = null;
                    throw var6_8;
                }
                catch (IOException var7_11) {
                    // empty catch block
                }
                throw var6_8;
            }
            {
                var5_10 = null;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 196->218)] { 
lbl46:
            // 1 sources

            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            break block26;
lbl50:
            // 1 sources

            catch (IOException var7_12) {
                // empty catch block
            }
        }
        if (this.isDebug) {
            System.out.println("Stopping remaining MessageListenerEngines.");
        }
        iterator = this.engineList.iterator();
        block14: while (true) {
            if (!iterator.hasNext()) {
                this.isRunning = false;
                return;
            }
            anEngine = (MessageListenerEngine)iterator.next();
            if (!anEngine.isAlive()) continue;
            if (this.isDebug) {
                System.out.println("Halting MessageListenerEngine #" + anEngine.engineID);
            }
            anEngine.halt();
            while (true) {
                if (!anEngine.isAlive()) {
                    if (!this.isDebug) continue block14;
                    System.out.println("MessageListenerEngine #" + anEngine.engineID + " halted.");
                    continue block14;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException var4_7) {
                    // empty catch block
                    continue;
                }
                break;
            }
            break;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void messageReceived(Message message) {
        if (this.messageListener != null) {
            this.messageListener.messageReceived(message);
        }
    }
}

