/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.discovery;

import com.alien.enterpriseRFID.discovery.AlienDiscoverySocketException;
import com.alien.enterpriseRFID.discovery.DiscoveryItem;
import com.alien.enterpriseRFID.discovery.DiscoveryListener;
import com.alien.enterpriseRFID.util.XMLReader;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class NetworkDiscoveryListenerService
implements Runnable {
    public static final int DEFAULT_LISTENER_PORT = 3988;
    public static final int DEFAULT_LISTENER_TIMEOUT_SECONDS = 2;
    private DiscoveryListener discoveryListener;
    private Hashtable discoveryTable;
    private DatagramSocket datagramSocket;
    private int listenerPort;
    private Thread motor;
    public boolean isDebug = false;
    private boolean isRunning = false;

    public NetworkDiscoveryListenerService() {
        this(3988);
    }

    public NetworkDiscoveryListenerService(int listenerPort) {
        this.listenerPort = listenerPort;
        this.discoveryTable = new Hashtable();
    }

    public DiscoveryListener getDiscoveryListener() {
        return this.discoveryListener;
    }

    public void setDiscoveryListener(DiscoveryListener discoveryListener) {
        this.discoveryListener = discoveryListener;
    }

    public void startService() throws AlienDiscoverySocketException {
        this.startService(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startService(boolean doPing) throws AlienDiscoverySocketException {
        this.stopService();
        try {
            this.datagramSocket = new DatagramSocket(this.listenerPort);
            this.datagramSocket.setSoTimeout(2000);
        }
        catch (SocketException ex) {
            throw new AlienDiscoverySocketException("Unable to open a socket to receive reader heartbeats.\n" + ex.getMessage());
        }
        this.motor = new Thread(this);
        this.motor.setPriority(1);
        this.motor.start();
        if (this.isDebug) {
            System.out.println("Listening for reader heartbeats on UDP port " + this.listenerPort);
        }
        if (!doPing) return;
        try {
            while (true) {
                if (this.isRunning) {
                    if (this.isDebug) {
                        System.out.println("Sending ping packet");
                    }
                    String buf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Alien-RFID-Reader-Command>\r\n  <COMMAND>HeartbeatNow</COMMAND>\r\n</Alien-RFID-Reader-Command>\r\n\u0000";
                    InetAddress socketAddr = InetAddress.getByName("255.255.255.255");
                    DatagramPacket pingPacket = new DatagramPacket(buf.getBytes(), buf.length(), socketAddr, this.listenerPort);
                    this.datagramSocket.send(pingPacket);
                    return;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new AlienDiscoverySocketException("Unable to send a heartbeat ping packet.\n" + e.getMessage());
        }
    }

    public void stopService() {
        if (this.datagramSocket == null && this.motor == null) {
            return;
        }
        try {
            this.datagramSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.datagramSocket = null;
        this.motor = null;
    }

    public void run() {
        this.isRunning = true;
        do {
            try {
                byte[] buffer = new byte[1024];
                DatagramPacket datagramPacket = new DatagramPacket(buffer, buffer.length);
                this.datagramSocket.receive(datagramPacket);
                this.discoveryItemReceived(datagramPacket);
                this.checkForExpiredLeases();
                Thread.sleep(100L);
            }
            catch (InterruptedIOException iioe) {
                this.checkForExpiredLeases();
            }
            catch (Exception e) {
                if (this.datagramSocket != null) {
                    System.out.println("Error Listening for Discovery Packets... stopping Service");
                    System.out.println(e.toString());
                }
                this.motor = null;
            }
        } while (this.motor != null);
        this.isRunning = false;
        this.stopService();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void discoveryItemReceived(DatagramPacket datagramPacket) {
        block4: {
            String datagramText = "Not Decoded";
            try {
                XMLReader reader;
                Hashtable topLevelTable;
                String dataString;
                datagramText = new String(datagramPacket.getData());
                if (this.isDebug) {
                    System.out.println("heartbeat = " + datagramText);
                }
                if ((dataString = (String)(topLevelTable = (reader = new XMLReader(datagramText)).readXML()).get("ALIEN-RFID-READER-HEARTBEAT")) == null) {
                    throw new Exception("No <ALIEN-RFID-READER-HEARTBEAT> Tag Found");
                }
                reader.setXMLString(dataString);
                Hashtable table = reader.readXML();
                DiscoveryItem discoveryItem = new DiscoveryItem();
                discoveryItem.setReaderName((String)table.get("READERNAME"));
                discoveryItem.setReaderType((String)table.get("READERTYPE"));
                discoveryItem.setCommandPort((String)table.get("COMMANDPORT"));
                discoveryItem.setLeaseTime((String)table.get("HEARTBEATTIME"));
                discoveryItem.setReaderMACAddress((String)table.get("MACADDRESS"));
                discoveryItem.setReaderAddress((String)table.get("IPADDRESS"));
                discoveryItem.setReaderVersion((String)table.get("READERVERSION"));
                discoveryItem.setConnection("Network");
                this.discoveryItemReceived(discoveryItem);
            }
            catch (Exception e) {
                if (!this.isDebug) break block4;
                System.out.println("Error decoding a Discovery Item Datagram Packet");
                System.out.println("   DatagramText : " + datagramText);
                System.out.println("   Exception : " + e.toString());
            }
        }
    }

    private void discoveryItemReceived(DiscoveryItem discoveryItem) {
        String key;
        DiscoveryItem existingDiscoveryItem;
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        if ((existingDiscoveryItem = (DiscoveryItem)this.discoveryTable.get(key = discoveryItem.toKey())) != null) {
            existingDiscoveryItem.update(discoveryItem);
            if (this.discoveryListener != null) {
                this.discoveryListener.readerRenewed(existingDiscoveryItem);
            }
        } else {
            this.discoveryTable.put(key, discoveryItem);
            if (this.discoveryListener != null) {
                this.discoveryListener.readerAdded(discoveryItem);
            }
        }
    }

    private void checkForExpiredLeases() {
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        if (this.discoveryTable.size() <= 0) {
            return;
        }
        long currentTime = new Date().getTime();
        Enumeration elements = this.discoveryTable.elements();
        while (elements.hasMoreElements()) {
            DiscoveryItem discoveryItem = (DiscoveryItem)elements.nextElement();
            long deltaTime = currentTime - discoveryItem.getLastHeartbeat();
            if (deltaTime <= (long)((discoveryItem.getLeaseTime() + 10) * 1000)) continue;
            this.discoveryItemExpired(discoveryItem);
        }
    }

    public void discoveryItemExpired(DiscoveryItem discoveryItem) {
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        this.discoveryTable.remove(discoveryItem.toKey());
        if (this.discoveryListener != null) {
            this.discoveryListener.readerRemoved(discoveryItem);
        }
    }

    public void allDiscoveryItemsExpired() {
        Enumeration elements = this.discoveryTable.elements();
        while (elements.hasMoreElements()) {
            DiscoveryItem di = (DiscoveryItem)elements.nextElement();
            this.discoveryItemExpired(di);
        }
    }

    public DiscoveryItem[] getDiscoveryItems() {
        if (this.discoveryTable == null) {
            this.discoveryTable = new Hashtable();
        }
        DiscoveryItem[] results = new DiscoveryItem[this.discoveryTable.size()];
        Enumeration items = this.discoveryTable.elements();
        int counter = 0;
        while (items.hasMoreElements()) {
            results[counter++] = (DiscoveryItem)items.nextElement();
        }
        return results;
    }

    private InetAddress getLocalWiredInetAddress() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface netface = e.nextElement();
                if (netface.getName().equals("lo")) continue;
                Enumeration<InetAddress> e2 = netface.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ip = e2.nextElement();
                    if (netface.getDisplayName().toLowerCase().indexOf("wireless") >= 0) continue;
                    return ip;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int getListenerPort() {
        return this.listenerPort;
    }

    public void setListenerPort(int listenerPort) {
        this.listenerPort = listenerPort;
    }
}

