/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.util;

import com.alien.enterpriseRFID.util.Converters;

public class BitMath {
    public static byte[] reverseBitArray(byte[] bitArray) {
        byte[] reply = new byte[bitArray.length];
        int i = 0;
        while (i < bitArray.length) {
            reply[bitArray.length - 1 - i] = bitArray[i];
            ++i;
        }
        return reply;
    }

    public static byte[] getBitArray(byte[] byteArray) throws IllegalArgumentException {
        return BitMath.getBitArray(byteArray, 0, byteArray.length);
    }

    public static byte[] getBitArray(byte[] byteArray, int offset, int length) throws IllegalArgumentException {
        if (byteArray == null) {
            throw new IllegalArgumentException("Byte Array is NULL in getBitArray method");
        }
        byte[] bitArray = new byte[length * 8];
        int i = 0;
        while (i < length) {
            byte b = byteArray[i + offset];
            int j = 0;
            while (j < 8) {
                byte result = 0;
                if ((b & 0x80) != 0) {
                    result = 1;
                }
                bitArray[i * 8 + j] = result;
                b = (byte)(b << 1);
                ++j;
            }
            ++i;
        }
        return bitArray;
    }

    public static byte[] getByteArray(byte[] bitArray) throws IllegalArgumentException {
        if (bitArray == null) {
            throw new IllegalArgumentException("Bit Array is NULL in getByteArray method");
        }
        if (bitArray.length == 0) {
            return new byte[1];
        }
        int byteLength = bitArray.length / 8;
        if (byteLength * 8 < bitArray.length) {
            ++byteLength;
        }
        byte[] byteArray = new byte[byteLength];
        int byteIndex = byteLength - 1;
        int bitIndex = bitArray.length - 1;
        int bitValue = 1;
        do {
            if (bitArray[bitIndex] == 1) {
                byteArray[byteIndex] = (byte)(byteArray[byteIndex] | bitValue);
            }
            --bitIndex;
            if ((bitValue *= 2) <= 128) continue;
            bitValue = 1;
            --byteIndex;
        } while (bitIndex >= 0);
        return byteArray;
    }

    public static long getValue(byte[] bitArray, int start, int length) throws IllegalArgumentException {
        if (bitArray == null) {
            throw new IllegalArgumentException("Bit Array is NULL in getValue method");
        }
        if (start < 0 || start > bitArray.length) {
            throw new IllegalArgumentException("Start Parameter is out of range in getValue method");
        }
        if (length + start > 64) {
            throw new IllegalArgumentException("Length Parameter is out of range in getValue method");
        }
        long results = 0L;
        int i = 0;
        while (i < length) {
            results <<= 1;
            if (bitArray[i + start] == 1) {
                results |= 1L;
            }
            ++i;
        }
        return results;
    }

    public static byte[] setValue(byte[] bitArray, long value, int start, int length) throws IllegalArgumentException {
        if (bitArray == null) {
            throw new IllegalArgumentException("Bit Array is NULL in setValue method");
        }
        if (start < 0 || start > bitArray.length) {
            throw new IllegalArgumentException("Start Parameter is out of range in setValue method");
        }
        if (length + start > 64) {
            throw new IllegalArgumentException("Length Parameter is out of range in setValue method");
        }
        int i = 0;
        while (i < length) {
            int bitIndex = start + length - i - 1;
            bitArray[bitIndex] = 0;
            if ((value & 1L) == 1L) {
                bitArray[bitIndex] = 1;
            }
            value >>= 1;
            ++i;
        }
        return bitArray;
    }

    public static void validate(String valueName, long value, int bitCount) throws IllegalArgumentException {
        long maximumValue = 0L;
        int i = 0;
        while (i < bitCount) {
            maximumValue = (maximumValue << 2) + 1L;
            ++i;
        }
        if (value < 0L || value > maximumValue) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(String.valueOf(valueName) + " value is out of Range : " + value + "\n");
            buffer.append("Range is limited by " + bitCount + " bits which equates to numerical");
            buffer.append(" values of 0-" + maximumValue + " decimal or ");
            buffer.append("0-" + Long.toHexString(maximumValue) + " hex");
            throw new IllegalArgumentException(buffer.toString());
        }
    }

    public static short generateLRC16Checksum(byte[] byteArray, int offset, int length) {
        int loByte = 0;
        int i = 0;
        while (i < length) {
            loByte = (loByte & 0x80) == 0 ? (int)((byte)(loByte * 2)) : (int)((byte)(loByte * 2 + 1));
            loByte = (byte)(loByte ^ byteArray[i + offset]);
            ++i;
        }
        byte hiByte = (byte)(0xFF & ~loByte);
        short result = (short)((hiByte & 0xFF) << 8);
        result = (short)(result + (loByte & 0xFF));
        return result;
    }

    public static int generateCRC16Checksum09(byte[] byteArray, int offset, int length) throws IllegalArgumentException {
        int pop;
        int polynomial = 2065;
        int value = 65535;
        int reverseValue = 0;
        byte[] bitArray = BitMath.getBitArray(byteArray);
        int i = bitArray.length - 1;
        while (i >= 0) {
            pop = value & 0x8000;
            value = (value & Short.MAX_VALUE) << 1;
            if (bitArray[i] == 1) {
                value |= 1;
            }
            if (pop != 0) {
                value ^= polynomial;
            }
            --i;
        }
        i = 0;
        while (i < 16) {
            pop = value & 0x8000;
            value = (value & Short.MAX_VALUE) << 1;
            if (pop != 0) {
                value ^= polynomial;
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            pop = value & 0x8000;
            value = (value & Short.MAX_VALUE) << 1;
            reverseValue >>= 1;
            if (pop != 0) {
                reverseValue |= 0x8000;
            }
            ++i;
        }
        return reverseValue;
    }

    public static int generateCRC16Checksum10(byte[] byteArray, int offset, int length) throws IllegalArgumentException {
        int carry;
        int polynomial = 4129;
        int preload = 65535;
        byte[] bitArray = BitMath.getBitArray(byteArray);
        int CRCReg = preload;
        int i = 0;
        while (i < bitArray.length) {
            carry = CRCReg & 0x8000;
            CRCReg = (CRCReg & Short.MAX_VALUE) << 1;
            if (bitArray[i] == 1) {
                ++CRCReg;
            }
            if (carry != 0) {
                CRCReg ^= polynomial;
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            carry = CRCReg & 0x8000;
            CRCReg = (CRCReg & Short.MAX_VALUE) << 1;
            if (carry != 0) {
                CRCReg ^= polynomial;
            }
            ++i;
        }
        return CRCReg;
    }

    public static int generateCRC16Checksum10(String tagID) throws IllegalArgumentException {
        byte[] byteArray = Converters.fromHexString(tagID);
        return BitMath.generateCRC16Checksum10(byteArray, 0, byteArray.length);
    }
}

