/*
 * Decompiled with CFR 0.152.
 */
package com.alien.enterpriseRFID.reader;

import com.alien.enterpriseRFID.reader.AlienClassOEMReader;
import com.alien.enterpriseRFID.reader.AlienReaderCommandErrorException;
import com.alien.enterpriseRFID.reader.AlienReaderConnectionException;
import com.alien.enterpriseRFID.reader.AlienReaderConnectionRefusedException;
import com.alien.enterpriseRFID.reader.AlienReaderException;
import com.alien.enterpriseRFID.reader.AlienReaderNotValidException;
import com.alien.enterpriseRFID.reader.AlienReaderTimeoutException;
import com.alien.enterpriseRFID.reader.TimedSocket;
import com.alien.enterpriseRFID.util.Converters;
import com.alien.enterpriseRFID.util.SerialManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;

public abstract class AbstractReader {
    public static final int DEBUG_OFF = 0;
    public static final int DEBUG_TEXT = 1;
    public static final int DEBUG_BYTES = 2;
    public static final int DEFAULT_TIMEOUT = 10000;
    public static final int TIMEOUTMODE_COMMAND = 0;
    public static final int TIMEOUTMODE_CHARACTER = 1;
    private SerialManager serialManager;
    protected Socket socket;
    private String networkAddress;
    private int networkPort;
    private int timeOutMilliseconds;
    private int timeOutMode;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean validateOpen;
    private int debugLevel;
    private static final int INPUT_BUFFER_SIZE = 256000;
    private byte[] inputBuffer;
    private int inputBufferPosition;
    private String readerReply;
    private String readerReplyKeyword;
    private String readerReplyValueString;
    private int readerReplyValueInt;

    public AbstractReader() {
        this.setDebugLevel(0);
        this.setValidateOpen(true);
        this.setTimeOutMilliseconds(10000);
        this.inputBuffer = new byte[256000];
        this.inputBufferPosition = 0;
        this.setTimeOutMode(0);
        boolean serialLibsPresent = false;
        try {
            Class.forName("javax.comm.CommPort");
            serialLibsPresent = true;
        }
        catch (ClassNotFoundException cnfe) {
            try {
                Class.forName("gnu.io.CommPort");
                serialLibsPresent = true;
            }
            catch (ClassNotFoundException cnfe2) {
                System.err.println("Serial Mananger Instance Failed - Serial Classes Not Present");
            }
        }
        if (serialLibsPresent) {
            this.serialManager = new SerialManager();
            this.setSerialBaudRate(115200);
        }
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    public boolean isValidateOpen() {
        return this.validateOpen;
    }

    public void setValidateOpen(boolean validateOpen) {
        this.validateOpen = validateOpen;
    }

    public int getTimeOutMilliseconds() {
        return this.timeOutMilliseconds;
    }

    public void setTimeOutMilliseconds(int timeOutMilliseconds) {
        this.timeOutMilliseconds = timeOutMilliseconds;
    }

    public void setTimeOutMode(int timeoutMode) {
        this.timeOutMode = timeoutMode;
    }

    public int getTimeOutMode() {
        return this.timeOutMode;
    }

    public void setAddress(String address, int port) {
        if (port > 0) {
            this.setNetworkConnection(address, port);
        } else {
            this.setSerialConnection(address);
        }
    }

    public String getAddress() {
        if (this.networkAddress != null) {
            return "Network: " + this.networkAddress + ":" + this.networkPort;
        }
        if (this.serialManager != null) {
            return "Serial: " + this.serialManager.getSerialPortName();
        }
        return "Unknown";
    }

    public void setSerialConnection(String serialPortName) {
        this.close();
        if (this.serialManager != null) {
            this.serialManager.setSerialPortName(serialPortName);
        }
        this.networkAddress = null;
    }

    public void setSerialBaudRate(int serialBaudRate) {
        this.close();
        if (this.serialManager != null) {
            this.serialManager.setSerialBaudRate(serialBaudRate);
        }
    }

    public void setNetworkConnection(String networkAddress, int networkPort) {
        this.close();
        this.networkAddress = networkAddress;
        this.networkPort = networkPort;
        if (this.serialManager != null) {
            this.serialManager.setSerialPortName(null);
        }
    }

    public void setConnection(String connectionMethod) {
        int colonPosition = connectionMethod.indexOf(":");
        if (colonPosition > 0) {
            String networkAddress = connectionMethod.substring(0, colonPosition);
            String networkPort = connectionMethod.substring(colonPosition + 1);
            int port = Integer.valueOf(networkPort);
            this.setNetworkConnection(networkAddress, port);
        } else {
            this.setSerialConnection(connectionMethod);
        }
    }

    public void setConnection(String networkAddress, int networkPort) {
        this.setNetworkConnection(networkAddress, networkPort);
    }

    public void open() throws AlienReaderNotValidException, AlienReaderTimeoutException, AlienReaderConnectionRefusedException, AlienReaderConnectionException {
        block12: {
            if (this.isOpen()) {
                return;
            }
            this.close();
            try {
                if (this.networkAddress != null) {
                    this.openNetworkConnection();
                } else {
                    this.openSerialConnection();
                }
                if (!this.isValidateOpen()) break block12;
                try {
                    this.receiveString(false);
                    this.doReaderCommand("");
                }
                catch (AlienReaderException alienReaderException) {
                    // empty catch block
                }
                if (this instanceof AlienClassOEMReader) {
                    this.doReaderCommand("Get ReaderVersion");
                    break block12;
                }
                String readerName = null;
                try {
                    this.sendString("\u0001Get ReaderName\r\n");
                    readerName = this.receiveString(true);
                }
                catch (AlienReaderCommandErrorException alienReaderCommandErrorException) {
                    // empty catch block
                }
                if (readerName != null && !readerName.startsWith("ReaderName = ")) {
                    StringBuffer result = new StringBuffer();
                    result.append("Not A Valid Alien RFID Reader.\n");
                    result.append("A device has been found at \"" + this.getAddress() + "\" but is not recognized as a valid Alien RFID Reader.\n");
                    throw new AlienReaderNotValidException(result.toString());
                }
            }
            catch (AlienReaderTimeoutException ate) {
                this.close();
                StringBuffer result = new StringBuffer();
                result.append("Time Out trying to open a connection with a Reader.\n");
                result.append("There is either no Reader connected at \"" + this.getAddress() + "\" ");
                result.append("or the Reader is switched off.\n");
                result.append("Please check all cables to the Reader and make sure the Reader power is on.\n");
                throw new AlienReaderTimeoutException(result.toString());
            }
            catch (AlienReaderCommandErrorException acee) {
                StringBuffer result = new StringBuffer();
                result.append("Not A Valid Alien RFID Reader.\n");
                result.append("A device has been found at \"" + this.getAddress() + "\" but the reader couldn't report a valid ReaderType.\n");
                result.append(acee.getMessage());
                throw new AlienReaderNotValidException(result.toString());
            }
        }
    }

    public boolean isOpen() {
        if (this.socket != null) {
            return true;
        }
        return this.serialManager != null && this.serialManager.getSerialPort() != null;
    }

    protected void openSerialConnection() throws AlienReaderConnectionException {
        if (this.serialManager == null) {
            StringBuffer buffer = new StringBuffer("No Serial Ports Available.\n");
            buffer.append("The Java Class Libraries for Serial Communication are not present on this machine.\n");
            throw new AlienReaderConnectionException(buffer.toString());
        }
        if (this.debugLevel > 0) {
            System.out.println("Opening Serial Connection:");
            System.out.println("    Serial Port = " + this.serialManager.getSerialPortName());
            System.out.println("    Baud Rate = " + this.serialManager.getSerialBaudRate());
        }
        this.serialManager.setSerialPortTimeout(this.getTimeOutMilliseconds());
        try {
            this.serialManager.openSerialConnection();
        }
        catch (Exception e) {
            this.close();
            StringBuffer result = new StringBuffer();
            if (e.getMessage().indexOf("Port currently owned") >= 0) {
                result.append(e.getMessage() + ".\n");
                result.append("If a Reader is connected to this port, make sure that no\n");
                result.append("other software is running that could also be using this port.\n");
                result.append("For example turn off PalmPilot HotSync or Microsoft PDA ActiveSync software.\n");
                throw new AlienReaderConnectionException(result.toString());
            }
            throw new AlienReaderConnectionException(e.getMessage());
        }
        this.setInputStream(this.serialManager.getInputStream());
        this.setOutputStream(this.serialManager.getOutputStream());
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void openNetworkConnection() throws AlienReaderConnectionRefusedException, AlienReaderTimeoutException, AlienReaderConnectionException {
        if (this.debugLevel > 0) {
            System.out.println("Opening Network Connection:");
            System.out.println("    Network Address = " + this.networkAddress);
            System.out.println("    Network Port = " + this.networkPort);
        }
        try {
            this.socket = TimedSocket.getSocket(this.networkAddress, this.networkPort, this.timeOutMilliseconds);
            this.setInputStream(this.socket.getInputStream());
            this.setOutputStream(this.socket.getOutputStream());
        }
        catch (UnknownHostException uhe) {
            this.close();
            throw new AlienReaderConnectionException("Unknown Host: " + this.networkAddress + " is not a valid network address");
        }
        catch (IOException ioe) {
            this.close();
            if (ioe.getMessage().indexOf("timed out") >= 0) {
                StringBuffer buffer = new StringBuffer("Connection Time Out\n");
                buffer.append("Time Out trying to communicate with a Reader.\n");
                buffer.append("There is either no Reader at the specified address or the Reader is switched off.\n");
                buffer.append("Please check all cables to the Reader and make sure the Reader power is on.\n");
                throw new AlienReaderTimeoutException(buffer.toString());
            }
            if (ioe.getMessage().indexOf("Connection refused") >= 0) {
                StringBuffer buffer = new StringBuffer("Connection Refused\n");
                buffer.append("The device is either a Reader that is already busy and accepting no more connections \n");
                buffer.append("or the device is not an Alien RFID Reader.\n");
                throw new AlienReaderConnectionRefusedException(buffer.toString());
            }
            throw new AlienReaderConnectionException(ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test() throws AlienReaderConnectionException {
        try {
            try {
                this.open();
            }
            catch (AlienReaderException ae) {
                throw new AlienReaderConnectionException(ae.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.close();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.close();
            return;
        }
    }

    public void close() {
        if (this.networkAddress != null) {
            try {
                this.sendString("q\r\n");
            }
            catch (AlienReaderException alienReaderException) {
                // empty catch block
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            this.inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.outputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.serialManager != null) {
            this.serialManager.close();
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
        this.inputBufferPosition = 0;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public synchronized String doReaderCommand(String command) throws AlienReaderTimeoutException, AlienReaderConnectionException, AlienReaderCommandErrorException {
        this.readerReply = "";
        this.readerReplyKeyword = "";
        this.readerReplyValueString = "";
        this.readerReplyValueInt = 0;
        if (command != null && command.length() > 300) {
            System.err.println("Truncating Command to 300 bytes.");
            command = command.substring(0, 300);
        }
        this.sendString("\u0001" + command + "\r\n");
        try {
            this.readerReplyValueString = this.readerReply = this.receiveString(true).trim();
        }
        catch (AlienReaderTimeoutException arte) {
            throw new AlienReaderTimeoutException("Reader Time Out waiting for Reply to command: \"" + command + "\".");
        }
        catch (AlienReaderException ae) {
            this.readerReply = "Error: " + ae.getMessage();
        }
        if (this.readerReply.startsWith("Boot> ")) {
            throw new AlienReaderConnectionException("Reader is still Booting... please try again in a few seconds.");
        }
        int index = this.readerReply.indexOf("=");
        if (index >= 0) {
            this.readerReplyKeyword = this.readerReply.substring(0, index - 1).trim();
            this.readerReplyValueString = this.readerReply.substring(index + 1).trim();
            try {
                this.readerReplyValueInt = new Integer(this.readerReplyValueString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.readerReply.toLowerCase().startsWith("error") || this.readerReplyValueString.toLowerCase().startsWith("error")) {
            throw new AlienReaderCommandErrorException(this.readerReply);
        }
        return this.readerReply;
    }

    public String getReaderReply() {
        return this.readerReply;
    }

    public String getReaderReplyKeyword() {
        return this.readerReplyKeyword;
    }

    public String getReaderReplyValueString() {
        return this.readerReplyValueString;
    }

    public int getReaderReplyValueInt() {
        return this.readerReplyValueInt;
    }

    public void clearInputBuffer() {
        this.inputBufferPosition = 0;
    }

    public void sendString(String text) throws AlienReaderConnectionException {
        if (!this.isOpen()) {
            return;
        }
        if (text == null) {
            text = "";
        }
        byte[] byteArray = text.getBytes();
        if (this.debugLevel == 1) {
            System.out.println("\nWrite: " + text.trim());
        }
        if (this.debugLevel == 2) {
            System.out.println("\nWrite: " + Converters.toHexString(byteArray, 0, byteArray.length, " "));
            System.out.println("     = " + Converters.toAsciiString(byteArray));
        }
        try {
            this.outputStream.write(byteArray);
            this.outputStream.flush();
        }
        catch (IOException ioe) {
            throw new AlienReaderConnectionException(ioe.getMessage());
        }
    }

    public String receiveString(boolean blockForInput) throws AlienReaderTimeoutException, AlienReaderCommandErrorException {
        if (!this.isOpen()) {
            return "";
        }
        long startTime = System.currentTimeMillis();
        boolean exit = false;
        if (!blockForInput) {
            exit = true;
        }
        int nullPosition = -1;
        int readLength = 0;
        int currentBufferPosition = this.inputBufferPosition;
        int availableBytes = 0;
        block4: while (true) {
            block23: {
                try {
                    while (this.inputStream != null && (availableBytes = this.inputStream.available()) > 0) {
                        readLength = this.inputStream.read(this.inputBuffer, currentBufferPosition, availableBytes);
                        if (readLength > 0) {
                            if (this.debugLevel == 2) {
                                System.out.println(" Read: " + Converters.toHexString(this.inputBuffer, currentBufferPosition, readLength, " "));
                                System.out.println("     = " + Converters.toAsciiString(this.inputBuffer, currentBufferPosition, readLength));
                            } else if (this.debugLevel == 1) {
                                System.out.println(" Read: " + Converters.toAsciiString(this.inputBuffer, currentBufferPosition, readLength));
                            }
                            if (this.getTimeOutMode() == 1) {
                                startTime = System.currentTimeMillis();
                            }
                            currentBufferPosition += readLength;
                            int i = 0;
                            while (i < currentBufferPosition) {
                                if (i < 256000 && this.inputBuffer[i] == 0) {
                                    exit = true;
                                    nullPosition = i;
                                }
                                ++i;
                            }
                        }
                        if (exit) break;
                        try {
                            Thread.sleep(1L);
                            continue block4;
                        }
                        catch (InterruptedException i) {
                            // empty catch block
                        }
                    }
                    if (exit) break block23;
                    int i = 0;
                    while (i < currentBufferPosition) {
                        if (i < 256000 && this.inputBuffer[i] == 0) {
                            exit = true;
                            nullPosition = i;
                            break;
                        }
                        ++i;
                    }
                }
                catch (IOException ioe) {
                    if (ioe.getMessage().toLowerCase().indexOf("rxreadycount") >= 0) {
                        throw new AlienReaderCommandErrorException("Stream closed");
                    }
                    throw new AlienReaderCommandErrorException(ioe.getMessage());
                }
            }
            if (System.currentTimeMillis() - startTime > (long)this.getTimeOutMilliseconds()) {
                if (!this.isOpen()) {
                    return "";
                }
                if (blockForInput) {
                    throw new AlienReaderTimeoutException("Time Out Waiting for Input Data");
                }
            }
            if (exit) break;
        }
        String result = "";
        if (nullPosition >= 0) {
            result = new String(this.inputBuffer, 0, nullPosition + 1);
            int remainingBytes = currentBufferPosition - (nullPosition + 1);
            System.arraycopy(this.inputBuffer, nullPosition + 1, this.inputBuffer, 0, remainingBytes);
            this.inputBufferPosition = remainingBytes;
        } else {
            result = new String(this.inputBuffer, 0, currentBufferPosition);
            this.inputBufferPosition = 0;
        }
        return result;
    }

    public String receiveLine() throws AlienReaderTimeoutException, AlienReaderCommandErrorException {
        if (!this.isOpen()) {
            return "";
        }
        long startTime = System.currentTimeMillis();
        boolean exit = false;
        int terminatorPosition = -1;
        int readLength = 0;
        int currentBufferPosition = this.inputBufferPosition;
        int availableBytes = 0;
        do {
            block14: {
                try {
                    int i;
                    block3: while ((availableBytes = this.inputStream.available()) > 0) {
                        readLength = this.inputStream.read(this.inputBuffer, currentBufferPosition, availableBytes);
                        if (readLength <= 0) continue;
                        if (this.debugLevel == 2) {
                            System.out.println(" Read: " + Converters.toHexString(this.inputBuffer, currentBufferPosition, readLength, " "));
                            System.out.println("     = " + Converters.toAsciiString(this.inputBuffer, currentBufferPosition, readLength));
                        }
                        currentBufferPosition += readLength;
                        i = 0;
                        while (i < currentBufferPosition - 1) {
                            if (i + 1 < 256000 && this.inputBuffer[i] == 13 && this.inputBuffer[i + 1] == 10) {
                                exit = true;
                                terminatorPosition = i;
                                continue block3;
                            }
                            ++i;
                        }
                    }
                    if (exit) break block14;
                    i = 0;
                    while (i < currentBufferPosition - 1) {
                        if (i + 1 < 256000 && this.inputBuffer[i] == 13 && this.inputBuffer[i + 1] == 10) {
                            exit = true;
                            terminatorPosition = i;
                            break;
                        }
                        ++i;
                    }
                }
                catch (IOException ioe) {
                    throw new AlienReaderCommandErrorException(ioe.getMessage());
                }
            }
            if (System.currentTimeMillis() - startTime <= (long)this.getTimeOutMilliseconds()) continue;
            if (!this.isOpen()) {
                return "";
            }
            throw new AlienReaderTimeoutException("Time Out Waiting for Input Data");
        } while (!exit);
        String result = "";
        if (terminatorPosition >= 0) {
            result = new String(this.inputBuffer, 0, terminatorPosition + 2);
            int remainingBytes = currentBufferPosition - (terminatorPosition + 2);
            System.arraycopy(this.inputBuffer, terminatorPosition + 2, this.inputBuffer, 0, remainingBytes);
            this.inputBufferPosition = remainingBytes;
        } else {
            result = new String(this.inputBuffer, 0, currentBufferPosition);
            this.inputBufferPosition = 0;
        }
        if (this.debugLevel == 1) {
            System.out.println(" Read: " + result.trim());
        }
        return result;
    }

    public int bringIntoRange(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    protected void dumpStack() {
        try {
            throw new Exception("Stack Dump");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
    }
}

